package com.transsion.ad.bidding.icon

import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.bidding.BiddingTAdditionalListener
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.ps.PSDistributionRequestManager
import com.transsion.ad.ps.PsLinkUtils
import com.transsion.ad.ps.model.RecommendInfo
import com.transsion.ad.scene.SceneCommonConfig

/**
 * @author shmizhangxinbing
 * @date : 2025/8/20 19:56
 * @description: PS 兜底接口请求
 */
class BiddingPSDistributionProvider : BiddingTAdditionalListener() {

    private var mListener: BiddingTAdditionalListener? = null   // 通用回调接口
    private var isFilteringInstalled: Boolean = false           // 是否过滤易已安装


    // =============================== 接口请求回调 ==================================================


    override fun onBiddingBuyOutError(p0: TAdErrorCode?, plans: AdPlans?) {
        super.onBiddingBuyOutError(p0, plans)
        mListener?.onBiddingBuyOutError(p0, plans)
    }

    override fun onPSDistributionReady(data: MutableList<RecommendInfo>?) {
        super.onPSDistributionReady(data)
        val value: MutableList<RecommendInfo>?
        if (isFilteringInstalled) {
            // 过滤一下数据
            val temporaryStoragePs: MutableList<RecommendInfo> = mutableListOf()
            data?.forEach { itemInfo ->
                // 判断当前应用是否已经安装 -- 如果已经安装了那就不向用户展示了
                if (PsLinkUtils.checkAppInstalled(itemInfo.packageName).not()) {
                    temporaryStoragePs.add(itemInfo)
                }
            }
            value = temporaryStoragePs
        } else {
            value = data
        }

        // 将结果回调出去
        mListener?.onPSDistributionReady(value)
    }


    // =============================================================================================


    fun destroy() {
        mListener = null
    }

    /**
     * 设置回调
     */
    fun setListener(listener: BiddingTAdditionalListener?) {
        mListener = listener
    }

    /**
     * 是否过滤已安装
     */
    fun setFilteringInstalled(isFilteringInstalled: Boolean) {
        this.isFilteringInstalled = isFilteringInstalled
    }

    /**
     * 加载广告
     */
    suspend fun loadAd(
        pageIndex: Int = 0,
        scene: String,
        pushModel: String = "",
    ) {
        PSDistributionRequestManager.getPsLinkListV2(
            pageIndex = pageIndex,
            pageSize = getX(scene = scene),
            scene = scene,
            pushModel = pushModel,
            listener = this
        )
    }

    /**
     * 获取 PS列表请求数量
     */
    private fun getX(scene: String): Int {
        return SceneCommonConfig.getSceneX(
            sceneId = scene, default = PSDistributionRequestManager.PAGE_SIZE
        )
    }

}