package com.transsion.ad.bidding.interstitial

import android.annotation.SuppressLint
import android.view.View
import android.widget.FrameLayout
import com.transsion.ad.R
import com.transsion.ad.bidding.base.AbsBiddingActivity
import com.transsion.ad.databinding.ActivityBiddingBuyOutInterstitialHalfScreenLayoutBinding
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.scene.SceneGlobalConfig
import com.transsion.ad.view.AdTagView

/**
 * @author shmizhangxinbing
 * @date : 2025/6/3 16:43
 * @description: 半屏广告样式，支持视频和图片
 */
class BiddingBuyOutBuyOutInterstitialHalfScreenActivity : AbsBiddingActivity() {

    private var binding: ActivityBiddingBuyOutInterstitialHalfScreenLayoutBinding? = null


    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_INTERSTITIAL

    override fun getLogTag(): String = AdLogger.TAG_AD_INTERSTITIAL

    override fun getSubContentView(): View? {
        binding = ActivityBiddingBuyOutInterstitialHalfScreenLayoutBinding.inflate(layoutInflater)
        return binding?.root
    }

    override fun getMediaContain(): FrameLayout? = binding?.container

    override fun getVolumeContainer(): FrameLayout? = binding?.flVolumeContainer

    override fun getCountDownTimes(): Int = SceneGlobalConfig.getInterstitialCd()

    override fun showAdInformation() {
        binding?.flCloseContainer?.setOnClickListener {
            finishAdActivity()
        }

        binding?.viewMember?.setOnClickListener {
            startMemberActivity()
        }
    }

    @SuppressLint("StringFormatMatches")
    override fun refreshCountDownView(i: Int) {
        binding?.tvCd?.apply {
            visibility = View.VISIBLE
            text = i.toString()
        }
    }

    override fun onAdCompletion() {
        binding?.flCloseContainer?.visibility = View.VISIBLE
        binding?.tvCd?.visibility = View.GONE
    }

    override fun showCloseAdDialog() {
        //TODO("Not yet implemented")
    }

    override fun getAdIcon(): View? = findViewById<AdTagView>(R.id.adIcon)

}