package com.transsion.ad.bidding.interstitial

import android.app.Activity
import android.text.TextUtils
import com.blankj.utilcode.util.Utils
import com.hisavana.common.bean.TAdRequestBody
import com.hisavana.mediation.ad.TBaseAd
import com.hisavana.mediation.ad.TInterstitialAd
import com.transsion.ad.bidding.base.AbsBiddingInterceptHiSavanaAdManager
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.scene.SceneCommonConfig
import com.transsion.ad.strategy.AdContextManager

/**
 * @author shmizhangxinbing
 * @date : 2025/6/3 20:35
 * @description:
 */
class BiddingHiSavanaInterstitialProvider : AbsBiddingInterceptHiSavanaAdManager() {

    companion object {

        /**
         * 因为所有的HiSavana 广告位ID都是服务端下发的,所以客户端会有多个对象
         */
        private val mAdMap by lazy {
            HashMap<String, BiddingHiSavanaInterstitialProvider>()
        }

        /**
         * 通过广告位ID获取广告加载对象
         */
        fun getManager(sceneId: String?): BiddingHiSavanaInterstitialProvider? {
            if (TextUtils.isEmpty(sceneId)) {
                return null
            }
            val hiSavanaPlacementId =
                SceneCommonConfig.getHiSavanaPlacementId(sceneId) ?: return null
            var manager = mAdMap[hiSavanaPlacementId]
            if (null == manager) {
                manager = BiddingHiSavanaInterstitialProvider()
                manager.setPlacementId(hiSavanaPlacementId)
                mAdMap[hiSavanaPlacementId] = manager
            }
            return manager
        }
    }


    // =============================================================================================


    /***广告加载对象*/
    private var tInterstitialAd: TInterstitialAd? = null

    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_INTERSTITIAL

    override fun getAdInstance(): TBaseAd<*>? {
        // 如果对象不存在，那就创建新的
        if (null == tInterstitialAd) {
            tInterstitialAd = TInterstitialAd(Utils.getApp(), getPlacementId())
            tInterstitialAd?.setRequestBody(
                TAdRequestBody.AdRequestBodyBuild().setAdditionalListener(this).build()
            )
        }
        return tInterstitialAd
    }

    override fun show(topActivity: Activity, ctxMap: Map<String, Any>?) {
        if (AdContextManager.isDangerGenre(ctxMap)) {
            tInterstitialAd?.setContainVulgarContent(true)
        }
        tInterstitialAd?.show(topActivity)
    }

    override fun reset() {
        tInterstitialAd?.destroy()
        tInterstitialAd = null
    }

    override fun getLogTag(): String = AdLogger.TAG_AD_INTERSTITIAL
}