package com.transsion.ad.bidding.splash

import android.content.Context
import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.bidding.base.AbsAdBidding
import com.transsion.ad.bidding.gemini.AbsBiddingBuyOutGemini
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.bidding.gemini.BiddingBuyOutSplashGemini
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.monopoly.model.MbAdType

/**
 * @author shmizhangxinbing
 * @date : 2025/5/30 10:18
 * @description: 开屏广告加载
 */
class BiddingSplashManager : AbsAdBidding() {

    private val gemini = BiddingBuyOutSplashGemini()


    // =================================== BuyOut 广告回调 开屏广告需要特殊处理 =========================


    override fun onBiddingBuyOutClose(plans: AdPlans?) {
        super.onBiddingBuyOutClose(plans)
        // TODO 开屏广告特殊处理
        getListener()?.onBiddingBuyOutClose(plans)
        destroy()
    }


    // ====================================== 子类实现逻辑 ===========================================


    override fun getLogTag(): String = AdLogger.TAG_AD_SPLASH

    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_SPLASH

    override fun getGemini(): AbsBiddingBuyOutGemini = gemini

    override fun addHiSavanaProvider(
        biddingPlan: MutableList<BiddingIntermediateMaterialBean>, adPlans: AdPlans
    ) {
        // TODO 当前开屏不支持 Hi程序化广告
    }


    // =================================== 展示广告 ==================================================


    /**
     * 展示广告 -- 接收到加载成功的回调之后调用
     */
    fun showSplash(appLayout: Int?, context: Context?) {
        runCatching {
            if (null != getMaxEcpmObject()?.plans) {
                context?.let {
                    gemini.setAppLayoutId(appLayout)
                    gemini.setListener(this@BiddingSplashManager).registerReceiver()
                        .startActivity(it, getSceneId(), getMaxEcpmObject()?.plans)
                }
            } else {
                // 理论上来说这里是不会调用的，不排除API调用错误在展示之前调用了 destroy()
                onBiddingError(
                    TAdErrorCode(
                        MbAdSource.MB_AD_SOURCE_BUY_OUT, "getAdPlan() == null"
                    )
                )
            }
        }.getOrElse {
            // 理论上来说这里是不会调用的，不排除API调用错误在展示之前调用了 destroy()
            onBiddingError(
                TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_BUY_OUT, "${it.message}"
                )
            )
        }
    }

}