package com.transsion.ad.bidding.video

import android.annotation.SuppressLint
import android.content.pm.ActivityInfo
import android.content.res.Configuration
import android.os.Bundle
import android.text.TextUtils
import android.util.Log
import android.view.View
import android.widget.FrameLayout
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.content.ContextCompat
import com.blankj.utilcode.util.SizeUtils
import com.bumptech.glide.Glide
import com.gyf.immersionbar.BarHide
import com.gyf.immersionbar.ImmersionBar
import com.transsion.ad.R
import com.transsion.ad.bidding.base.AbsBiddingActivity
import com.transsion.ad.databinding.ActivityBiddingBuyOutVideoUnspecifiedLayoutBinding
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.scene.SceneGlobalConfig
import com.transsion.ad.util.TextWithDividerConfig
import com.transsion.ad.util.TextWithDividerHelper
import com.transsion.ad.util.ViewUtil
import com.transsion.ad.view.AdTagView

/**
 * @author connor
 * @date : 2025/8/15
 * @description: 自适应横竖屏包断激励视频广告
 */
class BiddingBuyOutVideoAutoFullScreenActivity : AbsBiddingActivity() {

    private var isCanClickClose = false
    private var binding: ActivityBiddingBuyOutVideoUnspecifiedLayoutBinding? = null // 页面数据

    override fun setRequestedOrientation() {
        requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED
    }

    override fun withConfig(with: ImmersionBar) {
        val orientation = resources.configuration.orientation
        if (orientation == Configuration.ORIENTATION_LANDSCAPE) {
            with.hideBar(BarHide.FLAG_HIDE_STATUS_BAR) // 横屏隐藏状态栏
        } else {
            with.hideBar(BarHide.FLAG_SHOW_BAR) // 竖屏显示状态栏
        }
    }

    // =============================================================================================


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        updateLayoutForOrientation(resources.configuration.orientation)
    }

    override fun onConfigurationChanged(newConfig: Configuration) {
        super.onConfigurationChanged(newConfig)
        updateLayoutForOrientation(newConfig.orientation)

        ImmersionBar.with(this).apply {
            if (newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE) {
                hideBar(BarHide.FLAG_HIDE_STATUS_BAR) // 横屏隐藏
            } else {
                hideBar(BarHide.FLAG_SHOW_BAR)
            }
        }.init()
    }

    private fun updateLayoutForOrientation(orientation: Int) {
        updateLayout(orientation == Configuration.ORIENTATION_LANDSCAPE)
    }

    fun updateLayout(isLandscape: Boolean) {
        binding?.viewCd?.let {
            (it.layoutParams as ConstraintLayout.LayoutParams).topMargin =
                SizeUtils.dp2px(if (isLandscape) 12f else 44f)
        }
        binding?.clAdInfo?.let {
            it.layoutParams.width = SizeUtils.dp2px(if (isLandscape) 360f else 336f)
        }

        binding?.tvAdTitle?.let {
            it.maxLines = if (isLandscape) 1 else 2
        }

        binding?.tvAdDesc?.let {
            it.maxLines = if (isLandscape) 2 else 3
        }
    }

    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_VIDEO

    override fun getLogTag(): String = AdLogger.TAG_AD_VIDEO

    override fun getSubContentView(): View? {
        binding = ActivityBiddingBuyOutVideoUnspecifiedLayoutBinding.inflate(layoutInflater)
        return binding?.root
    }

    override fun getMediaContain(): FrameLayout? = binding?.container

    override fun getVolumeContainer(): FrameLayout? = binding?.flVolumeContainer

    override fun getCountDownTimes(): Int = SceneGlobalConfig.getVideoCd()

    override fun showAdInformation() {
        // 广告主信息 展示
        setAdvertiserInformation()
        // 广告点击事件
        ViewUtil.multipleClickListener(
            findViewById<FrameLayout>(R.id.clAdEndLayout)
        ) {
            adClick()
        }

        binding?.llMember?.setOnClickListener {
            startMemberActivity()
        }

        // 关闭按钮
        binding?.ivClose?.setOnClickListener {
            if (isCanClickClose.not()) {
                // 只有在最后10秒的时候才能点击
                onLog(
                    level = Log.DEBUG,
                    msg = "showAdInformation() --> setOnClickListener() --> 只有在最后10秒的时候才能点击"
                )
                return@setOnClickListener
            }
            showCloseAdDialog()
            //finishAdActivity()
        }
        binding?.ivAdClose?.setOnClickListener {
            finishAdActivity()
        }
    }

    @SuppressLint("StringFormatMatches")
    override fun refreshCountDownView(i: Int) {
        if (i <= 10) {
            isCanClickClose = true
            binding?.ivClose?.setImageResource(R.mipmap.ad_video_01)
        } else {
            binding?.ivClose?.setImageResource(R.mipmap.ad_video_03)
        }

        if (i == getCountDownTimes()) {
            binding?.llMember?.visibility = View.VISIBLE
        }
        // 倒计时开始了
        val timeText = "${i}s "
//        val rewardText = " Claim Reward"
//        val config = TextWithDividerConfig(
//            lineColor = ContextCompat.getColor(this, R.color.ad_white_20),
//            rightTextColor = ContextCompat.getColor(this, R.color.ad_white_60)
//        )
//        val spannable = TextWithDividerHelper.create(timeText, rewardText, config)
//        binding?.tvCd?.text = spannable
        binding?.tvCd?.text = timeText

        // i= 1 的时候，skip 可点击
        if (i == 0) {
            binding?.llMember?.visibility = View.GONE
            //ivVolume?.visibility = View.GONE
            adRewarded()
        }
    }

    override fun onAdCompletion() {
        binding?.clAdEndLayout?.visibility = View.VISIBLE
    }

    override fun showCloseAdDialog() {
        if (isCanClickClose.not()) {
            // 只有在最后10秒的时候才能点击
            onLog(
                level = Log.DEBUG, msg = "showCloseAdDialog() --> 只有在最后10秒的时候才能展示"
            )
            return
        }

        setShowCloseAdDialog(isShow = true)
        BiddingCloseAdDialog().setCallback(closeAdCallback = {
            finishAdActivity()
        }, resumeAdCallback = {
            setShowCloseAdDialog(isShow = false)
        }).showDialog(this, "CloseAdDialog")
    }

    override fun getAdIcon(): View? = findViewById<AdTagView>(R.id.adIcon)


    // ======================================== 广告展示 =============================================


    private fun setAdvertiserInformation() {
        kotlin.runCatching {
            binding?.tvAvatar?.let {
                if (TextUtils.isEmpty(getAdPlan()?.advertiserAvatarPath)) {
                    Glide.with(this).load(getAdPlan()?.advertiserAvatar).into(it)
                } else {
                    Glide.with(this).load(getAdPlan()?.advertiserAvatarPath).into(it)
                }
            }
            binding?.tvTitle?.text = getAdMaterialList()?.title
            binding?.tvDesc?.text = getAdMaterialList()?.desc
            binding?.tvBtn?.text = getAdMaterialList()?.buttonText
        }

        kotlin.runCatching {
            binding?.tvAdAvatar?.let {
                if (TextUtils.isEmpty(getAdPlan()?.advertiserAvatarPath)) {
                    Glide.with(this).load(getAdPlan()?.advertiserAvatar).into(it)
                } else {
                    Glide.with(this).load(getAdPlan()?.advertiserAvatarPath).into(it)
                }
            }

            binding?.tvAdTitle?.text = getAdMaterialList()?.title
            binding?.tvAdDesc?.text = getAdMaterialList()?.desc
            binding?.tvAdBtn?.text = getAdMaterialList()?.buttonText
        }
    }

}