package com.transsion.ad.monopoly.plan

import android.text.TextUtils
import com.transsion.ad.db.plan.MbAdDbPlans
import com.transsion.ad.monopoly.model.AdPlans

/**
 * @author: zhangxinbing
 * @date : 2025/3/20 10:57
 * @description: 广告源
 *
 * @link{com.transsion.ad.monopoly.model.AdPlans#adSource}
 */
internal object AdPlanSourceManager {

    /**
     * 广告计划类型
     */
    enum class AdPlanEnum(val value: String) {
        AD_PLAN_DEFAULT_AD_SRC("_DefaultAdSrc"),    // 自有包断
        AD_PLAN_AD_SOURCE_PS("AdSourcePS"),         // PS直投虚拟计划
        AD_PLAN_AD_SOURCE_MB_PS("AdSourceMBPS"),    // PS直投包断
        AD_PLAN_AD_SOURCE_HI("AdSourceHI"),         // HI程序化虚拟计划
    }

    /**
     * 当前计划是否是 HI程序化虚拟计划
     */
    fun isHiAdPlan(plan: AdPlans?): Boolean {
        return TextUtils.equals(plan?.adSource, AdPlanEnum.AD_PLAN_AD_SOURCE_HI.value)
    }

    fun isHiAdPlan(plan: MbAdDbPlans?): Boolean {
        return TextUtils.equals(plan?.adSource, AdPlanEnum.AD_PLAN_AD_SOURCE_HI.value)
    }

    /**
     * 当前计划是否是 PS虚拟计划
     */
    fun isMbPsAdPlan(plan: AdPlans?): Boolean {
        return TextUtils.equals(plan?.adSource, AdPlanEnum.AD_PLAN_AD_SOURCE_MB_PS.value)
    }

    fun isMbPsAdPlan(plan: MbAdDbPlans?): Boolean {
        return TextUtils.equals(plan?.adSource, AdPlanEnum.AD_PLAN_AD_SOURCE_MB_PS.value)
    }

    /**
     * 当前计划是否是 PS虚拟计划
     */
    fun isPsAdPlan(plan: AdPlans?): Boolean {
        return TextUtils.equals(plan?.adSource, AdPlanEnum.AD_PLAN_AD_SOURCE_PS.value)
    }

    fun isPsAdPlan(plan: MbAdDbPlans?): Boolean {
        return TextUtils.equals(plan?.adSource, AdPlanEnum.AD_PLAN_AD_SOURCE_PS.value)
    }

    /**
     * 当前计划是否是 自有计划
     */
    fun isDefaultAdPlan(plan: AdPlans?): Boolean {
        return TextUtils.equals(plan?.adSource, AdPlanEnum.AD_PLAN_DEFAULT_AD_SRC.value)
    }

    fun isDefaultAdPlan(plan: MbAdDbPlans?): Boolean {
        return TextUtils.equals(plan?.adSource, AdPlanEnum.AD_PLAN_DEFAULT_AD_SRC.value)
    }
}