package com.transsion.ad.strategy

import android.text.TextUtils
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.MbAdPlansBean
import com.transsion.ad.util.ListUtil


/**
 * @author: zhangxinbing
 * @date : 2025/2/18 20:49
 * @description: 广告上下文处理
 */
object AdContextManager {

    /**
     * 场景调用传值 --> 广告上下文 genre
     */
    const val AD_PLANS_SUBJECT_TYPE_GENRE = "genre"
    const val AD_PLANS_SUBJECT_TYPE_CHANNEL_ID = "channelId"
    const val AD_PLANS_SUBJECT_TYPE_CATEGORY = "category"

    /**
     * genre 服务端下发，本地保存
     */
    private const val AD_MMKV_KEY_LIMITER_STAGE_GENRE = "ad_plan_genre"


    // ================================== 包断广告使用 ===============================================


    /**
     * 获取广告需要的上下文容器
     */
    fun getCtxMap(genre: String?): MutableMap<String, Any> {
        // 上下文对象
        val ctxMap = mutableMapOf<String, Any>()
        ctxMap[AD_PLANS_SUBJECT_TYPE_GENRE] = genre ?: ""
        return ctxMap
    }


    // =================================== Hi广告使用 ===============================================


    /**
     * 获取 genreList
     */
    private fun getRemoteGenreList(): MutableList<String> {
        val genreList = mutableListOf<String>()
        runCatching {
            getRemoteGenre().split(",").forEach {
                genreList.add(it.uppercase())
            }
        }
        return genreList
    }

    /**
     * 获取 屏蔽类型
     */
    fun getRemoteGenre(): String =
        AdMmkv.mmkvWithID.getString(AD_MMKV_KEY_LIMITER_STAGE_GENRE, "") ?: ""

    /**
     * 判断当前是否是限制级场景
     */
    fun isDangerGenre(ctxMap: Map<String, Any>?): Boolean {
        return kotlin.runCatching {
            ctxMap?.let {
                // 全部转成大些进行匹配
                var genre = (it[AD_PLANS_SUBJECT_TYPE_GENRE] as? String)?.uppercase()
                genre = genre?.replace(" ", "")
                val split = genre?.split(",")

                // 这里需要将 channelId 考虑进来
                // ctxMap[MbAdContents.AD_PLANS_SUBJECT_TYPE_CHANNEL_ID] = arguments?.getInt(TAB_ID).toString()
                val channelId = (it[AD_PLANS_SUBJECT_TYPE_CHANNEL_ID] as? String)?.uppercase() ?: ""
                val toMutableList = split?.toMutableList()
                if (TextUtils.isEmpty(channelId).not()) {
                    toMutableList?.add(channelId)
                }

//                if (BuildConfig.DEBUG) {
//                    AdLogger.logSdkE("${javaClass.simpleName} --> isDangerGenre() --> toMutableList = $toMutableList -- getRemoteGenreList() = ${getRemoteGenreList()}")
//                }
                // 对比
                ListUtil.haveCommonElements(
                    toMutableList?.toMutableList() ?: mutableListOf(), getRemoteGenreList()
                )
            } ?: run {
                false
            }
        }.getOrElse {
            false
        }
    }

    /**
     * 保存限制级场景标识
     */
    fun saveGenre(mbAdPlansBean: MbAdPlansBean?) {
        AdMmkv.mmkvWithID.putString(AD_MMKV_KEY_LIMITER_STAGE_GENRE, mbAdPlansBean?.genre)
        AdLogger.logAdInit("${javaClass.simpleName} --> saveGenre() --> genre = ${mbAdPlansBean?.genre}")
    }
}