package com.transsion.ad.test

import android.content.Intent
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.transsion.ad.config.TestConfig
import com.transsion.ad.databinding.ActivityTestAdLayoutBinding
import com.transsion.ad.log.AdLogger

/**
 * @author shmizhangxinbing
 * @date : 2025/6/5 16:52
 * @description:
 */
class TestAdActivity : TestBaseActivity() {

    private lateinit var binding: ActivityTestAdLayoutBinding

    companion object {
        fun startAdActivity(activity: AppCompatActivity) {
            activity.startActivity(Intent(activity, TestAdActivity::class.java))
        }
    }


    // ==============================================================================================


    override fun getLogTag(): String = AdLogger.TAG_BASE

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        // 全局开关处理
        binding.btnGlobalSwitchConfig.let { btn ->
            showBtn()
            btn.setOnClickListener {
                TestConfig.setGlobalAdOff(TestConfig.isGlobalAdOff().not())
                showBtn()
            }
        }

        binding.btnLoadBannerAd.setOnClickListener {
            startActivity(Intent(this@TestAdActivity, TestAdBannerActivity::class.java))
        }

        binding.btnLoadSplashAd.setOnClickListener {
            startActivity(Intent(this@TestAdActivity, TestAdSplashActivity::class.java))
        }

        binding.btnLoadVideoAd.setOnClickListener {
            startActivity(Intent(this@TestAdActivity, TestAdVideoActivity::class.java))
        }

        binding.btnLoadInterstitialAd.setOnClickListener {
            startActivity(Intent(this@TestAdActivity, TestAdInterstitialActivity::class.java))
        }

        binding.btnLoadNativeAd.setOnClickListener {
            startActivity(Intent(this@TestAdActivity, TestAdNativeActivity::class.java))
        }

        binding.btnLoadNativeListAd.setOnClickListener {
            startActivity(Intent(this@TestAdActivity, TestAdNativeListActivity::class.java))
        }

        // 场景
        binding.btnSceneConfig.setOnClickListener {
            startActivity(Intent(this@TestAdActivity, TestAdSceneActivity::class.java))
        }

        // 广告计划
        binding.btnAdPlanConfig.setOnClickListener {
            startActivity(Intent(this@TestAdActivity, TestAdPlansActivity::class.java))
        }

        // 广告计划
        binding.btnOtherConfig.setOnClickListener {
            startActivity(Intent(this@TestAdActivity, TestAdOtherConfigActivity::class.java))
        }

        // 广告计划
        binding.btnPsOfferConfig.setOnClickListener {
            startActivity(Intent(this@TestAdActivity, TestAdPsOfferActivity::class.java))
        }

        binding.btnIrregularAd.setOnClickListener {
            startActivity(Intent(this@TestAdActivity, TestAdIrregularViewActivity::class.java))
        }

        binding.btnIconAd.setOnClickListener {
            startActivity(Intent(this@TestAdActivity, TestAdIconActivity::class.java))
        }

        binding.btnNonHitLog.apply {
            setOnClickListener {
                TestConfig.setNonHitLog(TestConfig.isNonHitLog()?.not())
                text = "未命中的广告计划 输出日志 = ${TestConfig.isNonHitLog()}"
            }
            text = "未命中的广告计划 输出日志 = ${TestConfig.isNonHitLog()}"
        }
    }

    private fun showBtn() {
        binding.btnGlobalSwitchConfig.text = if (TestConfig.isGlobalAdOff()) {
            "isGlobalAdOff = true"
        } else {
            "isGlobalAdOff = false"
        }
    }

}