package com.transsion.ad.test

import android.os.Bundle
import android.util.Log
import androidx.lifecycle.lifecycleScope
import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.bidding.BiddingTAdditionalListener
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.bidding.interstitial.BiddingInterstitialManager
import com.transsion.ad.databinding.ActivityTestAdInterstitialLayoutBinding
import com.transsion.ad.log.AdLogger
import kotlinx.coroutines.launch

/**
 * @author shmizhangxinbing
 * @date : 2025/6/9 10:43
 * @description:
 */
class TestAdInterstitialActivity : TestBaseActivity() {

    private lateinit var binding: ActivityTestAdInterstitialLayoutBinding
    private lateinit var interstitialManager: BiddingInterstitialManager

    private val interstitialListener = object : BiddingTAdditionalListener() {

        override fun onBiddingLoad(maxEcpmObject: BiddingIntermediateMaterialBean?) {
            super.onBiddingLoad(maxEcpmObject)
            interstitialManager.startAdActivity(this@TestAdInterstitialActivity)
        }

        override fun onBiddingError(p0: TAdErrorCode?) {
            super.onBiddingError(p0)
            onLog(level = Log.ERROR, msg = "onBiddingError() --> p0 = ${p0?.errorMessage}")
        }

        override fun onBiddingWrapperAdShowError(adSource: Int) {
            super.onBiddingWrapperAdShowError(adSource)
            onLog(level = Log.ERROR, msg = "onBiddingWrapperAdShowError() --> 展示失败")
        }
    }


    // =============================================================================================


    override fun getLogTag(): String = AdLogger.TAG_AD_INTERSTITIAL

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdInterstitialLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        interstitialManager = BiddingInterstitialManager()
        binding.btnLoadInterstitialAd.setOnClickListener {
            lifecycleScope.launch {
                interstitialManager.setSceneId("HotStartScene")
                interstitialManager.setCtxMap(null)
                interstitialManager.setContext(this@TestAdInterstitialActivity)
                interstitialManager.setListener(interstitialListener)
                interstitialManager.loadAd()
            }
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        interstitialManager.destroy()
    }

}