package com.transsion.ad.test

import android.os.Bundle
import androidx.recyclerview.widget.LinearLayoutManager
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.ad.R
import com.transsion.ad.databinding.ActivityTestAdIrregularLayoutBinding
import com.transsion.ad.log.AdLogger

/**
 * @author shmizhangxinbing
 * @date : 2025/7/21 14:30
 * @description:
 */
class TestAdIrregularViewActivity : TestBaseActivity() {

    private lateinit var binding: ActivityTestAdIrregularLayoutBinding


    // =============================================================================================


    override fun getLogTag(): String = AdLogger.TAG_AD_IRREGULAR

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdIrregularLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        // 加载广告
        binding.irregularView.setSceneId("TabDownloadIrregularFloatingScene")
        binding.irregularView.loadAd()

        // 初始化列表数据
        binding.rv.apply {
            val list = mutableListOf<String>()
            repeat(200) {
                list.add("我是谁 我在哪里 我要干什么 $it")
            }
            adapter = TestAdapter(list)
            layoutManager = LinearLayoutManager(this@TestAdIrregularViewActivity)
        }

        // 设置滚动监听
        binding.irregularView.setRecyclerView(binding.rv)
    }

    override fun onDestroy() {
        super.onDestroy()
        binding.irregularView.onAdViewDestroy()
    }

    class TestAdapter(strList: MutableList<String>) :
        BaseQuickAdapter<String, BaseViewHolder>(R.layout.item_test_irregular_layout, strList) {

        override fun convert(holder: BaseViewHolder, item: String) {
            holder.setText(R.id.btn, item)
        }
    }

}