package com.transsion.ad.test

import android.os.Bundle
import android.text.method.ScrollingMovementMethod
import com.google.gson.GsonBuilder
import com.transsion.ad.databinding.ActivityTestAdSceneLayoutBinding
import com.transsion.ad.log.AdLogger
import com.transsion.ad.scene.SceneStorage

/**
 * @author shmizhangxinbing
 * @date : 2025/6/19 14:28
 * @description:
 */
class TestAdSceneActivity : TestBaseActivity() {

    private lateinit var binding: ActivityTestAdSceneLayoutBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdSceneLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        val vc = "版本号 ${SceneStorage.getSceneVersion()}"
        binding.tvSceneVc.text = vc

        val sceneConfig = SceneStorage.getSceneConfig()
        binding.tvConfig.movementMethod = ScrollingMovementMethod() // 启用滚动
        binding.tvConfig.text = formatJson(sceneConfig)
    }

    override fun getLogTag(): String = AdLogger.TAG_BASE

    private fun formatJson(json: String?): String {
        val gson = GsonBuilder().setPrettyPrinting().create()
        try {
            // 解析 JSON 字符串并格式化
            val jsonElement = gson.fromJson(json, Any::class.java)
            return gson.toJson(jsonElement)
        } catch (e: Exception) {
            e.printStackTrace()
            return "Invalid JSON String"
        }
    }

}