package com.transsion.ad.view.native_ad

import android.app.Activity
import android.content.Context
import android.text.TextUtils
import android.util.AttributeSet
import android.util.Log
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import android.widget.ImageView
import android.widget.TextView
import com.blankj.utilcode.util.ConvertUtils.byte2FitMemorySize
import com.bumptech.glide.Glide
import com.transsion.ad.bidding.base.AbsBiddingAdLayoutProvider
import com.transsion.ad.bidding.base.AbsBiddingBuyOutView
import com.transsion.ad.bidding.base.BiddingAdLayoutProviderBean
import com.transsion.ad.log.AdLogger
import com.transsion.ad.view.blur.BlurTransformation
import kotlinx.coroutines.runBlocking

/**
 * @author shmizhangxinbing
 * @date : 2025/8/22 17:34
 * @description:
 */
class BiddingIconView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
) : AbsBiddingBuyOutView(context, attrs) {

    private var adProviderBean: BiddingAdLayoutProviderBean? = null
    private var mIsShowVolumeIcon: Boolean = true


    // =============================================================================================


    override fun getMediaContainer(): FrameLayout? {
        adProviderBean?.mediaId?.let { mediaId ->
            return adProviderBean?.layout?.findViewById(mediaId)
        }
        adProviderBean?.iconId?.let { mediaId ->
            return adProviderBean?.layout?.findViewById(mediaId)
        }
        return null
    }

    override fun isShowVolumeIcon(): Boolean = mIsShowVolumeIcon

    override fun getLogTag(): String = AdLogger.TAG_AD_ICON


    // =============================================================================================


    /**
     * 模拟点击
     */
    fun iconPerformClick() {
        // 调用父类封装好的点击事件
        onAdClick()
    }

    /**
     * Icon 渲染
     */
    fun bindIconView(adLayoutProvider: AbsBiddingAdLayoutProvider?) {

        // 数据校验
        if (getRecommendInfo() == null || adLayoutProvider == null) {
            return
        }

        // 修复线上问题
        // 在Android中使用Glide加载图片时，如果传入的context是view的context，可能会导致上述的IllegalArgumentException。
        // 这是因为view的context可能与Activity的生命周期不同步。
        if ((context as? Activity)?.isDestroyed == true) {
            onLog(
                level = Log.WARN, msg = "当前Activity销毁，广告就不需要展示了", writeToFile = false
            )
            return
        }

        val adProviderBean = adLayoutProvider.getAdLayoutProvider()
        this.adProviderBean = adProviderBean
        this.mIsShowVolumeIcon = adLayoutProvider.isShowVolumeIcon()

        // 设置标题
        adProviderBean.titleId?.let { titleId ->
            adProviderBean.layout.findViewById<TextView>(titleId)?.apply {
                text = getRecommendInfo()?.detail?.name
            }
        }

        // 设置描述
        adProviderBean.descriptionId?.let { descriptionId ->
            adProviderBean.layout.findViewById<TextView>(descriptionId)?.apply {
                text = getRecommendInfo()?.detail?.simpleDescription
            }
        }

        // 按钮文案
        adProviderBean.callToActionId?.let { callToActionId ->
            adProviderBean.layout.findViewById<TextView>(callToActionId)?.apply {
                text = getRecommendInfo()?.buttonText
                if (TextUtils.isEmpty(getRecommendInfo()?.buttonText)) {
                    visibility = View.GONE
                }
            }
        }

        // 大小
        runBlocking {
            adProviderBean.apkSizeId?.let { apkSizeId ->
                adProviderBean.layout.findViewById<TextView>(apkSizeId)?.apply {
                    text = byte2FitMemorySize(
                        getRecommendInfo()?.detail?.sourceSize?.toLong() ?: 0L, 1
                    )
                }
            }
        }

        // 评分
        adProviderBean.ratingId?.let { ratingId ->
            adProviderBean.layout.findViewById<TextView>(ratingId)?.apply {
                text = getRecommendInfo()?.detail?.star
            }
        }

//        // 广告点击事件
//        adProviderBean.layout.setOnClickListener {
//            iconClick()
//        }

        // Icon
        // 主图 -- 这里需要判断是视频还是图片 -- 测试 先开发图片
        adProviderBean.iconId?.let { iconId ->
            adProviderBean.layout.findViewById<FrameLayout>(iconId)?.apply {
                removeAllViews()
                // 大图 TODO 待优化
                val imageView = ImageView(context)
                imageView.scaleType = ImageView.ScaleType.FIT_CENTER
                Glide.with(context).load(getRecommendInfo()?.iconUrl).into(imageView)
                // 全屏展示
                addView(imageView)
            }
        }

        // 高斯模糊
        adProviderBean.burlBgId?.let { mediaId ->
            val imageViewBlur = adProviderBean.layout.findViewById<ImageView>(mediaId)
            imageViewBlur.scaleType = ImageView.ScaleType.CENTER_CROP
            // 如果本地地址是空的，那就不使用线上地址在线加载
            Glide.with(context).load(getRecommendInfo()?.iconUrl).transform(BlurTransformation(25))
                .into(imageViewBlur)
        }

        // TODO 曝光监测 需要调用
        addSession()

        // 组装View 将广告布局添加到容器中
        removeAllViews()
        addView(
            adProviderBean.layout, LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT
            )
        )
    }
}