package com.transsion.ad.view.native_ad

import android.content.Context
import android.text.TextUtils
import android.util.AttributeSet
import android.util.Log
import android.view.View
import android.widget.FrameLayout
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.bidding.BiddingTAdditionalListener
import com.transsion.ad.bidding.base.AbsBiddingBuyOutView
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.bidding.nativead.BiddingNativeManager
import com.transsion.ad.log.AdLogger
import kotlinx.coroutines.launch

/**
 * @author shmizhangxinbing
 * @date : 2025/8/20 14:12
 * @description: 矩形的非标广告 ,非标广告是特殊的Native广告
 */
class BiddingRectangleIrregularView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
) : AbsBiddingBuyOutView(context, attrs) {

    private var mMaxEcpmObject: BiddingIntermediateMaterialBean? = null // 广告数据
    private val mediaContainer: FrameLayout = FrameLayout(context) // 广告容器

    /**
     * 场景回调
     */
    private var mIrregularAdListener: BiddingTAdditionalListener? = null

    /**
     * 广告加载 结果回调
     */
    private var adNativeManager: BiddingNativeManager? = null
    private val adNativeListener = object : BiddingTAdditionalListener() {

        override fun onBiddingLoad(maxEcpmObject: BiddingIntermediateMaterialBean?) {
            super.onBiddingLoad(maxEcpmObject)
            // 广告数据
            mMaxEcpmObject = maxEcpmObject

            // 设置数据
            setAdPlans(maxEcpmObject?.plans)
            // 展示
            showMedia()
            visibility = View.VISIBLE // 整体可见
            mediaContainer.visibility = View.VISIBLE

            // 回调给调用场景
            mIrregularAdListener?.onBiddingLoad(maxEcpmObject)
        }

        override fun onBiddingError(p0: TAdErrorCode?) {
            super.onBiddingError(p0)
//            onLog(
//                level = Log.ERROR, msg = "onBiddingError() --> p0 = ${p0?.errorMessage}"
//            )
            visibility = View.GONE // 整体不可见

            // 回调给调用场景
            mIrregularAdListener?.onBiddingError(p0)
        }
    }


    // =============================================================================================


    init {
        addView(mediaContainer)
    }


    // =============================================================================================


    override fun getMediaContainer(): FrameLayout = mediaContainer

    override fun isShowVolumeIcon(): Boolean = false

    override fun getLogTag(): String = AdLogger.TAG_AD_IRREGULAR


    // =============================================================================================


    /**
     * 广告加载回调
     */
    fun setIrregularAdListener(listener: BiddingTAdditionalListener?) {
        mIrregularAdListener = listener
    }

    /**
     * 资源回收
     */
    fun onAdViewDestroy() {
        adNativeManager?.destroy()    // 广告加载对象资源回收
        removeAllViews()        // 移除所有View
        destroy()               // 当前View资源回收
    }

    /**
     * 加载广告
     */
    fun loadAd() {

        // 已经展示了就不再重复加载
        if (mMaxEcpmObject != null) {
            return
        }

        if (adNativeManager != null) {
            return
        }

        if (TextUtils.isEmpty(getSceneId())) {
            onLog(level = Log.ERROR, msg = "getSceneId() is empty")
        }

        adNativeManager = BiddingNativeManager()            // 非标广告是特殊的Native广告
        adNativeManager?.setSceneId(getSceneId())           // 场景ID
        adNativeManager?.setListener(adNativeListener)      // 广告加载结果回调

        // 将View的事件传递给Manager处理 曝光、点击
        setListener(adNativeManager)

        // 加载广告
        (context as? AppCompatActivity)?.lifecycleScope?.launch {
            adNativeManager?.loadAd()
        }
    }

}