package com.transsion.ad.web

import com.cloud.hisavana.sdk.bridge.HisavanaAdJsBridge
import android.graphics.Bitmap
import android.net.Network
import android.net.NetworkCapabilities
import android.os.Bundle
import android.os.SystemClock
import android.webkit.WebResourceError
import android.webkit.WebResourceRequest
import android.webkit.WebView
import com.blankj.utilcode.util.GsonUtils
import com.github.lzyzsd.jsbridge.BridgeWebView
import com.transsion.baselib.report.LogViewConfig
import com.transsion.baselib.report.Report
import com.transsion.lib_web.BaseLibWebFragment
import kotlin.collections.set

/**
 * @author: zhangxinbing
 * @date : 2025/4/24 14:26
 * @description:
 */
internal class AdWebFragment : BaseLibWebFragment() {


    private var isError = false

    override fun addJsInterface(bridgeWebView: BridgeWebView) {
        // Hisavana JSBridge
        bridgeWebView.addJavascriptInterface(
            HisavanaAdJsBridge(bridgeWebView), HisavanaAdJsBridge.INTERFACE_NAME
        )
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        logViewConfig.paramsMap["original_url"] = getUrl()
    }

    override fun onHiddenChanged(hidden: Boolean) {
        super.onHiddenChanged(hidden)
    }


    override fun onResume() {
        super.onResume()
        logViewConfig.resumeTime = SystemClock.elapsedRealtime()
    }

    override fun onPause() {
        super.onPause()
        if (isHidden.not()) {
            logViewConfig.paramsMap["is_from_cache"] =
                mWebViewLoaderManager?.isUserCache().toString()
            logViewConfig.paramsMap["dom"] = GsonUtils.toJson(loadInfoStats.dom_performance)
            Report.reportPT(logViewConfig)
        }
    }


    override fun onWebViewClientPageFinished(view: WebView, url: String) {
        super.onWebViewClientPageFinished(view, url)
        pageFinish(url)
    }

    override fun onConnected(network: Network, networkCapabilities: NetworkCapabilities) {
        if (!logViewConfig.isLoadSuccess && isError) {
            binding.bridgeWebView.reload()
        }
    }

    override fun onWebViewClientPageStarted(view: WebView, url: String, favicon: Bitmap?) {
        super.onWebViewClientPageStarted(view, url, favicon)
        logViewConfig.paramsMap["url"] = url
        isError = false
    }

    override fun onWebViewClientReceivedError(
        view: WebView?, request: WebResourceRequest, error: WebResourceError,
    ) {
        super.onWebViewClientReceivedError(view, request, error)
        isError = true
    }

    override fun onWebViewClientReceivedError(
        view: WebView?, request: Int, error: String?, failingUrl: String?,
    ) {
        super.onWebViewClientReceivedError(view, request, error, failingUrl)
        isError = true
    }

    val logViewConfig: LogViewConfig by lazy { LogViewConfig(pageName = "ad_web_page") }


    private fun pageFinish(url: String?) {
        logViewConfig.isLoadSuccess = loadInfoStats.isLoadSuccess
        logViewConfig.paramsMap["load_time"] = loadInfoStats.load_time.toString()
        logViewConfig.paramsMap["error_code"] = loadInfoStats.error_code.toString()
        logViewConfig.paramsMap["error_msg"] = loadInfoStats.error_msg

    }


}