/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001a\u0010\r\u001a\u00020\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\u000e"}, d2={"Lcom/transsion/ad/util/AppUtil;", "", "()V", "isAppInstalled", "", "context", "Landroid/content/Context;", "packageName", "", "isSystemApp", "openApp", "", "openAppInStore", "openThirdPartyApp", "lib_ad_release"})
public final class AppUtil {
    @NotNull
    public static final AppUtil INSTANCE = new AppUtil();

    private AppUtil() {
    }

    public final boolean isAppInstalled(@Nullable Context context, @Nullable String packageName) {
        boolean bl;
        CharSequence charSequence = packageName;
        if (charSequence == null || charSequence.length() == 0 || context == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            return false;
        }
        PackageManager packageManager2 = packageManager;
        try {
            if (Build.VERSION.SDK_INT >= 33) {
                packageManager2.getPackageInfo(packageName, PackageManager.PackageInfoFlags.of((long)0L));
            } else {
                packageManager2.getPackageInfo(packageName, 0);
            }
            bl = true;
        }
        catch (PackageManager.NameNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    public final boolean isSystemApp(@NotNull Context context, @Nullable String packageName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CharSequence charSequence = packageName;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(packageName, 0);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"packageManager.getApplicationInfo(packageName, 0)");
            ApplicationInfo applicationInfo2 = applicationInfo;
            bl = (applicationInfo2.flags & 1) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    public final void openApp(@Nullable Context context, @Nullable String packageName) {
        Intent launchIntent;
        Context context2 = context;
        if (context2 != null && (context2 = context2.getPackageManager()) != null) {
            String string2 = packageName;
            if (string2 == null) {
                string2 = "";
            }
            v2 = context2.getLaunchIntentForPackage(string2);
        } else {
            v2 = launchIntent = null;
        }
        if (launchIntent != null) {
            context.startActivity(launchIntent);
        }
    }

    public final void openAppInStore(@Nullable Context context, @Nullable String packageName) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + packageName)));
            Context context2 = context;
            if (context2 != null) {
                context2.startActivity(intent);
            }
        }
        catch (Exception e) {
            try {
                Unit unit;
                boolean bl = false;
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + packageName)));
                Context context3 = context;
                if (context3 != null) {
                    context3.startActivity(intent);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Object object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    public final void openThirdPartyApp(@Nullable Context context, @Nullable String packageName) {
        if (this.isAppInstalled(context, packageName)) {
            this.openApp(context, packageName);
        } else {
            this.openAppInStore(context, packageName);
        }
    }
}

