/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\t\u001a\u00020\u0004J\u0006\u0010\n\u001a\u00020\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004\u00a8\u0006\u000f"}, d2={"Lcom/transsion/ad/util/TimeUtil;", "", "()V", "convertTimestampToDate", "", "timestampInSeconds", "", "dateFormat", "(Ljava/lang/Long;Ljava/lang/String;)Ljava/lang/String;", "getCurrentDate", "getCurrentTimestamp", "isCurrentTimeInRange", "", "strStart", "strEnd", "lib_ad_release"})
public final class TimeUtil {
    @NotNull
    public static final TimeUtil INSTANCE = new TimeUtil();

    private TimeUtil() {
    }

    public final boolean isCurrentTimeInRange(@NotNull String strStart, @NotNull String strEnd) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)strStart, (String)"strStart");
        Intrinsics.checkNotNullParameter((Object)strEnd, (String)"strEnd");
        try {
            boolean bl = false;
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss", Locale.getDefault());
            Date startTime = dateFormat.parse(strStart);
            Date endTime = dateFormat.parse(strEnd);
            Date currentTime = dateFormat.parse(dateFormat.format(new Date()));
            object2 = Result.constructor-impl((Object)(currentTime == null ? false : currentTime.after(startTime) && currentTime.before(endTime)));
        }
        catch (Throwable dateFormat) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)dateFormat));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = false;
        }
        return (Boolean)object;
    }

    @NotNull
    public final String getCurrentDate() {
        Date currentDate = Calendar.getInstance().getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        String string2 = formatter.format(currentDate);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatter.format(currentDate)");
        return string2;
    }

    public final long getCurrentTimestamp() {
        Date date = new Date();
        return date.getTime();
    }

    @NotNull
    public final String convertTimestampToDate(@Nullable Long timestampInSeconds, @NotNull String dateFormat) {
        Intrinsics.checkNotNullParameter((Object)dateFormat, (String)"dateFormat");
        Long l = timestampInSeconds;
        long timestampInMilliseconds = l != null ? l : 0L;
        Date date = new Date(timestampInMilliseconds);
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat, Locale.getDefault());
        String string2 = sdf.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sdf.format(date)");
        return string2;
    }

    public static /* synthetic */ String convertTimestampToDate$default(TimeUtil timeUtil, Long l, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "yyyy-MM-dd";
        }
        return timeUtil.convertTimestampToDate(l, string2);
    }
}

