/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.db.pslink;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.transsion.ad.db.pslink.AttributionPoint;
import com.transsion.ad.db.pslink.AttributionPointDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class AttributionPointDao_Impl
implements AttributionPointDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AttributionPoint> __insertionAdapterOfAttributionPoint;
    private final AttributionPoint.TypeConverter __typeConverter = new AttributionPoint.TypeConverter();
    private final EntityDeletionOrUpdateAdapter<AttributionPoint> __deletionAdapterOfAttributionPoint;
    private final EntityDeletionOrUpdateAdapter<AttributionPoint> __updateAdapterOfAttributionPoint;

    public AttributionPointDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAttributionPoint = new EntityInsertionAdapter<AttributionPoint>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `attribution_points` (`id`,`psId`,`failCount`,`reportUrl`,`type`,`updateTimestamp`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, AttributionPoint value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getPsId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPsId());
                }
                stmt.bindLong(3, (long)value.getFailCount());
                if (value.getReportUrl() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getReportUrl());
                }
                String _tmp = AttributionPointDao_Impl.this.__typeConverter.fromAttributionType(value.getType());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                stmt.bindLong(6, value.getUpdateTimestamp());
            }
        };
        this.__deletionAdapterOfAttributionPoint = new EntityDeletionOrUpdateAdapter<AttributionPoint>(__db){

            public String createQuery() {
                return "DELETE FROM `attribution_points` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AttributionPoint value) {
                stmt.bindLong(1, (long)value.getId());
            }
        };
        this.__updateAdapterOfAttributionPoint = new EntityDeletionOrUpdateAdapter<AttributionPoint>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `attribution_points` SET `id` = ?,`psId` = ?,`failCount` = ?,`reportUrl` = ?,`type` = ?,`updateTimestamp` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AttributionPoint value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getPsId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPsId());
                }
                stmt.bindLong(3, (long)value.getFailCount());
                if (value.getReportUrl() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getReportUrl());
                }
                String _tmp = AttributionPointDao_Impl.this.__typeConverter.fromAttributionType(value.getType());
                if (_tmp == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp);
                }
                stmt.bindLong(6, value.getUpdateTimestamp());
                stmt.bindLong(7, (long)value.getId());
            }
        };
    }

    @Override
    public Object insertAttributionPoint(final AttributionPoint attributionPoint, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AttributionPointDao_Impl.this.__db.beginTransaction();
                try {
                    AttributionPointDao_Impl.this.__insertionAdapterOfAttributionPoint.insert((Object)attributionPoint);
                    AttributionPointDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AttributionPointDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object deleteAttributionPoint(final AttributionPoint attributionPoint, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AttributionPointDao_Impl.this.__db.beginTransaction();
                try {
                    AttributionPointDao_Impl.this.__deletionAdapterOfAttributionPoint.handle((Object)attributionPoint);
                    AttributionPointDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AttributionPointDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object updateAttributionPoint(final AttributionPoint attributionPoint, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AttributionPointDao_Impl.this.__db.beginTransaction();
                try {
                    AttributionPointDao_Impl.this.__updateAdapterOfAttributionPoint.handle((Object)attributionPoint);
                    AttributionPointDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AttributionPointDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object getAttributionPointsByType(AttributionPoint.AttributionType type, Continuation<? super List<AttributionPoint>> continuation) {
        String _sql = "SELECT * FROM attribution_points WHERE type = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM attribution_points WHERE type = ?", (int)1);
        int _argIndex = 1;
        String _tmp = this.__typeConverter.fromAttributionType(type);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<AttributionPoint>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AttributionPoint> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)AttributionPointDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfPsId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"psId");
                    int _cursorIndexOfFailCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"failCount");
                    int _cursorIndexOfReportUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportUrl");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfUpdateTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updateTimestamp");
                    ArrayList<AttributionPoint> _result = new ArrayList<AttributionPoint>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        int _tmpId = _cursor.getInt(_cursorIndexOfId);
                        String _tmpPsId = _cursor.isNull(_cursorIndexOfPsId) ? null : _cursor.getString(_cursorIndexOfPsId);
                        int _tmpFailCount = _cursor.getInt(_cursorIndexOfFailCount);
                        String _tmpReportUrl = _cursor.isNull(_cursorIndexOfReportUrl) ? null : _cursor.getString(_cursorIndexOfReportUrl);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        AttributionPoint.AttributionType _tmpType = AttributionPointDao_Impl.this.__typeConverter.toAttributionType(_tmp_1);
                        long _tmpUpdateTimestamp = _cursor.getLong(_cursorIndexOfUpdateTimestamp);
                        AttributionPoint _item = new AttributionPoint(_tmpId, _tmpPsId, _tmpFailCount, _tmpReportUrl, _tmpType, _tmpUpdateTimestamp);
                        _result.add(_item);
                    }
                    ArrayList<AttributionPoint> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    @Override
    public Object getAllAttributionPoints(Continuation<? super List<AttributionPoint>> continuation) {
        String _sql = "SELECT * FROM attribution_points";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM attribution_points", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<AttributionPoint>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AttributionPoint> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)AttributionPointDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfPsId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"psId");
                    int _cursorIndexOfFailCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"failCount");
                    int _cursorIndexOfReportUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportUrl");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfUpdateTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updateTimestamp");
                    ArrayList<AttributionPoint> _result = new ArrayList<AttributionPoint>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        int _tmpId = _cursor.getInt(_cursorIndexOfId);
                        String _tmpPsId = _cursor.isNull(_cursorIndexOfPsId) ? null : _cursor.getString(_cursorIndexOfPsId);
                        int _tmpFailCount = _cursor.getInt(_cursorIndexOfFailCount);
                        String _tmpReportUrl = _cursor.isNull(_cursorIndexOfReportUrl) ? null : _cursor.getString(_cursorIndexOfReportUrl);
                        String _tmp = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        AttributionPoint.AttributionType _tmpType = AttributionPointDao_Impl.this.__typeConverter.toAttributionType(_tmp);
                        long _tmpUpdateTimestamp = _cursor.getLong(_cursorIndexOfUpdateTimestamp);
                        AttributionPoint _item = new AttributionPoint(_tmpId, _tmpPsId, _tmpFailCount, _tmpReportUrl, _tmpType, _tmpUpdateTimestamp);
                        _result.add(_item);
                    }
                    ArrayList<AttributionPoint> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    @Override
    public Object getTopAttributionPoints(long currentTimestamp, long timeThreshold, Continuation<? super AttributionPoint> continuation) {
        String _sql = "SELECT * FROM attribution_points WHERE ? - updateTimestamp >= ? ORDER BY CASE type WHEN 'CLICK' THEN 0 ELSE 1 END, failCount ASC, updateTimestamp DESC LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM attribution_points WHERE ? - updateTimestamp >= ? ORDER BY CASE type WHEN 'CLICK' THEN 0 ELSE 1 END, failCount ASC, updateTimestamp DESC LIMIT 1", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, currentTimestamp);
        _argIndex = 2;
        _statement.bindLong(_argIndex, timeThreshold);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<AttributionPoint>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AttributionPoint call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)AttributionPointDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    AttributionPoint _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfPsId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"psId");
                    int _cursorIndexOfFailCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"failCount");
                    int _cursorIndexOfReportUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"reportUrl");
                    int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"type");
                    int _cursorIndexOfUpdateTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updateTimestamp");
                    if (_cursor.moveToFirst()) {
                        int _tmpId = _cursor.getInt(_cursorIndexOfId);
                        String _tmpPsId = _cursor.isNull(_cursorIndexOfPsId) ? null : _cursor.getString(_cursorIndexOfPsId);
                        int _tmpFailCount = _cursor.getInt(_cursorIndexOfFailCount);
                        String _tmpReportUrl = _cursor.isNull(_cursorIndexOfReportUrl) ? null : _cursor.getString(_cursorIndexOfReportUrl);
                        String _tmp = _cursor.isNull(_cursorIndexOfType) ? null : _cursor.getString(_cursorIndexOfType);
                        AttributionPoint.AttributionType _tmpType = AttributionPointDao_Impl.this.__typeConverter.toAttributionType(_tmp);
                        long _tmpUpdateTimestamp = _cursor.getLong(_cursorIndexOfUpdateTimestamp);
                        _result = new AttributionPoint(_tmpId, _tmpPsId, _tmpFailCount, _tmpReportUrl, _tmpType, _tmpUpdateTimestamp);
                    } else {
                        _result = null;
                    }
                    AttributionPoint attributionPoint = _result;
                    return attributionPoint;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    @Override
    public Object isAttributionPointExists(String psId, AttributionPoint.AttributionType type, String reportUrl2, Continuation<? super Boolean> continuation) {
        String _sql = "SELECT EXISTS(SELECT 1 FROM attribution_points WHERE psId = ? AND type = ? AND reportUrl = ?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT EXISTS(SELECT 1 FROM attribution_points WHERE psId = ? AND type = ? AND reportUrl = ?)", (int)3);
        int _argIndex = 1;
        if (psId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, psId);
        }
        _argIndex = 2;
        String _tmp = this.__typeConverter.fromAttributionType(type);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 3;
        if (reportUrl2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, reportUrl2);
        }
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)AttributionPointDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Integer _tmp_1;
                    Boolean _result = _cursor.moveToFirst() ? ((_tmp_1 = _cursor.isNull(0) ? null : Integer.valueOf(_cursor.getInt(0))) == null ? null : Boolean.valueOf(_tmp_1 != 0)) : null;
                    Boolean bl = _result;
                    return bl;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

