package com.transsion.ad.bidding.banner

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.appcompat.widget.AppCompatImageView
import com.blankj.utilcode.util.Utils
import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.R
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.MbAdSource
import com.transsion.ad.strategy.AdTagManager
import com.transsion.ad.bidding.base.AbsBiddingBuyOutView
import com.transsion.ad.util.DebounceClickListener
import com.transsion.ad.view.AdTagView

/**
 * @author shmizhangxinbing
 * @date : 2025/5/28 17:28
 * @description: 包断BannerView
 */
class BiddingBuyOutBannerView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
) : AbsBiddingBuyOutView(context, attrs) {

    private var isMute = false
    private var mediaContainer: FrameLayout? = null


    // =============================================================================================


    override fun getMediaContainer(): FrameLayout? = mediaContainer

    override fun isShowVolumeIcon(): Boolean = true

    override fun getLogTag(): String = AdLogger.TAG_AD_BANNER

    /**
     * 展示广告
     */
    fun showAd() {
        // 渲染AdView
        assemble()
    }


    // ==================================== 渲染View ================================================


    /**
     * 渲染View
     */
    private fun assemble() {

        if (getAdPlans() == null) {
            getListener()?.onBiddingBuyOutShowError(
                p0 = TAdErrorCode(
                    MbAdSource.MB_AD_SOURCE_WRAPPER_AD, "adPlans is null"
                ), getMaxEcpmObject()
            )
            return
        }

        // 这里可以扩展不同样式的BannerView
        val nonBannerRoot = LayoutInflater.from(Utils.getApp())
            .inflate(R.layout.bidding_buy_out_banner_view, this, false)

        mediaContainer = nonBannerRoot.findViewById(R.id.flAdContainer)

        setClick(nonBannerRoot) // Ad View 点击事件
        setMute(nonBannerRoot) // 静音按钮处理

        // Ad 标识统一处理
        nonBannerRoot?.findViewById<AdTagView>(R.id.adIcon)?.apply {
            AdTagManager.handleForAdTagView(this)
        }

        // 展示媒体内容
        showMedia()

        // 添加到容器中
        addView(
            nonBannerRoot, ViewGroup.LayoutParams(
                ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT
            )
        )
    }

    /**
     * 静音按钮处理
     */
    private fun setMute(nonBannerRoot: View?) {
        nonBannerRoot?.findViewById<AppCompatImageView>(R.id.mute)?.apply {
            visibility = if (isMute) {
                View.VISIBLE
            } else {
                View.GONE
            }

            setOnClickListener {
                if (getOrPlayer()?.isMute() == true) {
                    getOrPlayer()?.setMute(false)
                    setImageResource(R.mipmap.ad_volumeon)
                } else {
                    getOrPlayer()?.setMute(true)
                    setImageResource(R.mipmap.ad_volumeoff)
                }
            }
        }
    }

    /**
     * Ad View 点击事件
     */
    private fun setClick(nonBannerRoot: View?) {
        nonBannerRoot?.setOnClickListener(DebounceClickListener {
            onAdClick()
        })
    }

}