package com.transsion.ad.bidding.interstitial

import android.view.Gravity
import android.view.View
import android.widget.FrameLayout
import android.widget.LinearLayout
import androidx.appcompat.widget.AppCompatImageView
import com.transsion.ad.bidding.base.AbsBiddingActivity
import com.transsion.ad.databinding.ActivityBiddingBuyOutInterstitialActionLayoutBinding
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.MbAdType

/**
 * @author shmizhangxinbing
 * @date : 2025/9/1 17:54
 * @description: 弹窗样式插屏广告
 */
class BiddingBuyOutInterstitialActionActivity : AbsBiddingActivity() {

    private var binding: ActivityBiddingBuyOutInterstitialActionLayoutBinding? = null

    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_INTERSTITIAL

    override fun getLogTag(): String = AdLogger.TAG_AD_INTERSTITIAL

    override fun getSubContentView(): View? {
        binding = ActivityBiddingBuyOutInterstitialActionLayoutBinding.inflate(layoutInflater)
        return binding?.root
    }

    override fun showAdInformation() {
        binding?.ivClose?.setOnClickListener {
            finishAdActivity()
        }

        // 关闭按钮延迟展示
        binding?.ivClose?.visibility = View.GONE
        binding?.root?.postDelayed({
            binding?.ivClose?.visibility = View.VISIBLE
        }, getDelayCloseTime() * 1000L)
    }

    override fun getMediaContain(): FrameLayout? = binding?.mediaContain

    override fun getVolumeContainer(): FrameLayout? = null

    override fun getCountDownTimes(): Int = 0

    override fun refreshCountDownView(i: Int) {}

    override fun onAdCompletion() {}

    override fun showCloseAdDialog() {}

    override fun getAdIcon(): View? = null

    override fun onVideoSizeChanged(width: Int, height: Int) {
        super.onVideoSizeChanged(width, height)
        onMediaContainSizeChange(width, height)
    }

    override fun onImageAdd(imageView: AppCompatImageView?, width: Int?, height: Int?) {
        super.onImageAdd(imageView, width, height)
        if (width != null && height != null) {
            onMediaContainSizeChange(width, height)
        }
    }


    // =============================================================================================


    /**
     * 根据资源调整容器的宽高
     */
    private fun onMediaContainSizeChange(width: Int, height: Int) {
        binding?.mediaContain?.let { group ->
            group.post {
                val layoutParams =
                    LinearLayout.LayoutParams(group.width, group.width * height / width)
                layoutParams.gravity = Gravity.CENTER
                group.layoutParams = layoutParams
                //onLog(msg = "width = $width --> height = $height")
            }
        }
    }

}