package com.transsion.ad.bidding.interstitial

import android.annotation.SuppressLint
import android.content.pm.ActivityInfo
import android.content.res.Configuration
import android.os.Bundle
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import com.blankj.utilcode.util.SizeUtils
import com.gyf.immersionbar.BarHide
import com.gyf.immersionbar.ImmersionBar
import com.transsion.ad.R
import com.transsion.ad.bidding.base.AbsBiddingActivity
import com.transsion.ad.databinding.ActivityBiddingBuyOutInterstitialLandLayoutBinding
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.scene.SceneGlobalConfig
import com.transsion.ad.view.AdTagView

/**
 * @author connor
 * @date : 2025/8/14
 * @description: 横屏样式插屏
 */
class BiddingBuyOutInterstitialAutoFullScreenActivity : AbsBiddingActivity() {

    private var binding: ActivityBiddingBuyOutInterstitialLandLayoutBinding? = null

    override fun setRequestedOrientation() {
        requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED
    }

    override fun withConfig(with: ImmersionBar) {
        val orientation = resources.configuration.orientation
        if (orientation == Configuration.ORIENTATION_LANDSCAPE) {
            with.hideBar(BarHide.FLAG_HIDE_STATUS_BAR) // 横屏隐藏状态栏
        } else {
            with.hideBar(BarHide.FLAG_SHOW_BAR) // 竖屏显示状态栏
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        window.attributes = window.attributes.apply {
            dimAmount = 0.8f
        }
        updateLayoutForOrientation(resources.configuration.orientation)
    }

    override fun onConfigurationChanged(newConfig: Configuration) {
        super.onConfigurationChanged(newConfig)
        updateLayoutForOrientation(newConfig.orientation)

        ImmersionBar.with(this)
            .apply {
                if (newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE) {
                    hideBar(BarHide.FLAG_HIDE_STATUS_BAR) // 横屏隐藏
                } else {
                    hideBar(BarHide.FLAG_SHOW_BAR)
                }
            }
            .init()
    }

    private fun updateLayoutForOrientation(orientation: Int) {
        updateLayout(orientation == Configuration.ORIENTATION_LANDSCAPE)
    }

    fun updateLayout(isLandscape: Boolean) {
        binding?.container?.let {
            it.layoutParams.width = if (isLandscape) SizeUtils.dp2px(426f) else ViewGroup.LayoutParams.MATCH_PARENT
            it.layoutParams.height = if (isLandscape) SizeUtils.dp2px(240f) else 0
        }
    }

    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_INTERSTITIAL

    override fun getLogTag(): String = AdLogger.TAG_AD_INTERSTITIAL

    override fun getSubContentView(): View? {
        binding = ActivityBiddingBuyOutInterstitialLandLayoutBinding.inflate(layoutInflater)
        return binding?.root
    }

    override fun getMediaContain(): FrameLayout? = binding?.container

    override fun getVolumeContainer(): FrameLayout? = binding?.flVolumeContainer

    override fun getCountDownTimes(): Int = SceneGlobalConfig.getInterstitialCd()

    override fun showAdInformation() {
        binding?.flCloseContainer?.setOnClickListener {
            finishAdActivity()
        }

        binding?.viewMember?.setOnClickListener {
            startMemberActivity()
        }
    }

    @SuppressLint("StringFormatMatches")
    override fun refreshCountDownView(i: Int) {
        binding?.tvCd?.apply {
            visibility = View.VISIBLE
            text = i.toString()
        }
    }

    override fun onAdCompletion() {
        binding?.flCloseContainer?.visibility = View.VISIBLE
        binding?.tvCd?.visibility = View.GONE
    }

    override fun showCloseAdDialog() {
        //
    }

    override fun getAdIcon(): View? = findViewById<AdTagView>(R.id.adIcon)

}