package com.transsion.ad.db.plan

import androidx.annotation.Keep
import androidx.room.Entity
import androidx.room.PrimaryKey
import java.io.Serializable

/**
 * @author: zhangxinbing
 * @date : 2023/12/21 19:23
 * @description:
 */
@Keep
@Entity(tableName = "mb_ad_db_plans")
data class MbAdDbPlans(
    @PrimaryKey var id: String,
    var version: String? = null,
    var name: String? = null,
    var startTime: String? = null,
    var endTime: String? = null,
    var extraConfig: String? = null,

    var displayTimes: Int? = null,
    var showedTimes: Int? = null,
    var showDate: String? = null,

    var advertiserName: String? = null,
    var advertiserAvatar: String? = null,
    var advertiserAvatarPath: String? = null,

    var brand: String? = null, // 广告定向投放设备品牌
    var denyBrand: String? = null, // 广告定向投放设备品牌
    var model: String? = null, // 广告定向投放机型
    var denyModel: String? = null, // 广告定向投放机型
    var country: String? = null, // 广告定向投放国家
    var scenes: String? = null, // 广告展现场景
    var adSource: String? = null,           // 广告来源 目前仅有ps一种
    var extAdSlot: String? = null,          // 广告位信息 跟着adSourcePS字段使用
    var adMaterialList: String? = null,//
    var adPlanUpdateTime: String? = null,//计划的最后更新时间
    var sort: Int? = Int.MAX_VALUE,

    // 2024-07-23 新增字段
    // 兜底广告计划
    // 广告计划状态 AdShowFirst: 优先 AdShowFinal: 兜底 default: AdShowLevelUnknown
    var adShowLevel: String? = null,
    var filterClientVersion: String? = null,
    var adPlanCreateTime: String? = null,
    var appStarDesc: String? = null,
    var appSizeDesc: String? = null,

    // MovieBox会员&内容广告屏蔽策略
    // https://transsioner.feishu.cn/docx/Pj84dFtm7oSSKnxEezBcOksTnqb
    var ctxEnableExpr: String? = null, // 广告计划上下文 -- 白名单
    var ctxDisableExpr: String? = null, // 广告计划上下文 -- 黑名单
    var ctxAttributeConfig: String? = null, // 上下文判断条件

    // 2024-12-02 新增字段
    var dispatchTimeStart: String? = null,  // 广告分发时间段开始时间
    var dispatchTimeEnd: String? = null,     // 广告分发时间段结束时间

    // 2025-03-12 新增字段
    var extImage: String? = null,       // 首页Banner展示广告计划 扩展图片

    // 2025-05-28 竞价需求 增加字段 // 竞价价格
    // https://transsioner.feishu.cn/docx/UUGndRUMmok5ODxCdFXcqavEnme
    var bidEcpmCent: Double? = null,
    var ecpmCent: Long? = null,

    // 当前计划是否有效
    // 2025-08-05
    // https://transsioner.feishu.cn/wiki/LmKMwmS8DieGdJkMDvPczVePnph
    // 修复 广告计划更新及时性导致的展示数量丢失问题处理
    var isValid: Boolean = false,

    // 表示当前落地页是否需要预加载
    val h5LinkPreload: Boolean = false,

    ) : Serializable