package com.transsion.ad.monopoly.intercept

import com.transsion.ad.db.plan.MbAdDbPlans

/**
 * @author: zhangxinbing
 * @date : 2024/8/20 20:22
 * @description: 广告计划上下文判断 白名单
 */
internal class AdSceneCtxEnableExprHandler : BaseAdSceneCtxExprHandler() {

    override fun getCtxExprString(
        sceneId: String, plans: MbAdDbPlans?, ctxMap: Map<String, Any>
    ): String? = plans?.ctxEnableExpr

    override fun getMissMsg(): String = "未命中 白名单,当前广告计划 不满足展示条件"

    override fun getHitMsg(): String = "命中 白名单,当前广告计划 满足展示条件"

    override fun goNext(enable: Boolean): Boolean = enable

}