package com.transsion.ad.monopoly.intercept

import com.transsion.ad.db.plan.MbAdDbPlans
import com.transsion.ad.monopoly.model.AdPlansHitResponse


/**
 * @author: zhangxinbing
 * @date : 2024/3/18 20:57
 * @description: 广告展示次数判断
 */
internal class ValidTimesHandler : AbsAdPlanInterceptHandler() {

    override suspend fun doHandle(
        sceneId: String, plans: MbAdDbPlans?, ctxMap: Map<String, Any>
    ): AdPlansHitResponse {

        // 已展示次数判断
        val displayTimes = plans?.displayTimes ?: 0
//        var showedTimes = plans?.showedTimes ?: 0
//        // 这里还需要判断一下日期，如果不是同一天的那展示次数就默认修改成0
//        val showDate = plans?.showDate
//        val currentDate = AdUtils.getCurrentDate()
//        if (TextUtils.equals(showDate, currentDate).not()) {
//            showedTimes = 0
//        }

        // 获取当天已经展示的次数
        val showedTimes = NonAdShowedTimesManager.getShowedTimes(plans)

        // 因为这个是最后一个了 所以直接返回结果
        // 当前条件通过继续下一个条件判断 -- 否则直接返回失败
        val isValidTimes = showedTimes < displayTimes
        return if (isValidTimes) {
            getChain()?.doHandle(sceneId, plans, ctxMap) ?: getDefaultRes()
        } else {
            AdPlansHitResponse(isHit = false, rejectMsg = "展示次数已经达到上限")
        }
    }
}