package com.transsion.ad.monopoly.model

import android.os.Parcelable
import com.transsion.ad.db.pslink.PsLinkAdPlan
import com.transsion.ad.ps.model.RecommendInfo
import kotlinx.parcelize.Parcelize

/**
 * @author: zhangxinbing
 * @date : 2025/2/13 20:56
 * @description:
 */
@Parcelize
data class AdMaterialList(
    val id: String? = null, // 广告素材id
    var type: String? = null, //  广告类型 -- 广告素材类型 TextAdMaterial: 图文 VideoAdMaterial: 视频
    var title: String? = null, // 广告标题
    var desc: String? = null, // 广告描述
    var buttonText: String? = null, // 广告按钮文案
    val h5Link: String? = null, // 广告H5链接
    val deeplink: String? = null, // 广告deeplink
    var image: MbAdImage? = null, // 图片
    val video: MbAdVideo? = null, // 视频
    var downloadMaterialSuccess: Boolean = false, // 标记当前资源是否现在成功
    var psRecommendInfo: RecommendInfo? = null, // PS Offer信息
    var psLinkAdPlan: PsLinkAdPlan? = null, // PS Offer 数据库对象
    var psLink: String? = null // 2025-05-22 预埋能力
) : Parcelable {

    companion object {
        const val NON_AD_TYPE_TEXT = "TextAdMaterial"
        const val NON_AD_TYPE_VIDEO = "VideoAdMaterial"
    }

}