package com.transsion.ad.monopoly.model

import android.text.TextUtils
import androidx.annotation.StringDef

/**
 * @author: zhangxinbing
 * @date : 2024/7/09 16:59
 * @description: 兜底广告计划
 */
@StringDef(
    MbAdShowLevel.MB_AD_SHOW_LEVEL_UN_KNOWN,
    MbAdShowLevel.MB_AD_SHOW_FIRST,
    MbAdShowLevel.MB_AD_SHOW_FINAL,
)
@Retention(AnnotationRetention.SOURCE)
annotation class MbAdShowLevel {
    companion object {
        const val MB_AD_SHOW_LEVEL_UN_KNOWN = "AdShowLevelUnknown" // default
        const val MB_AD_SHOW_FIRST = "AdShowFirst" // 优先
        const val MB_AD_SHOW_FINAL = "AdShowFinal" // 兜底

        /**
         * 是否是包断广告的兜底广告计划
         */
        fun isAdShowLevel(mAdPlan: AdPlans?): Boolean {
            return TextUtils.equals(MB_AD_SHOW_FINAL, mAdPlan?.adShowLevel)
        }
    }
}