package com.transsion.ad.ps.model


import android.os.Parcelable
import androidx.annotation.Keep
import com.hisavana.common.bean.TAdNativeInfo
import com.transsnet.launcherlib.PalmStoreDownLoadTaskInfo
import kotlinx.parcelize.IgnoredOnParcel
import kotlinx.parcelize.Parcelize
import java.io.Serializable

@Keep
@Parcelize
data class RecommendInfo(
    var categoryCode: String? = null,
    var categoryName: String? = null,
    var detail: ItemDetail? = null,
    var downloadCount: Int = 0,
    var iconUrl: String? = null,
    var itemID: String? = null,
    var offerDesc: String? = null,
    var packageName: String? = null,
    var simpleDescription: String? = null,
    var size: Long = 0,
    var star: String? = null,
    var verifyGoogle: String? = null,
    var versionCode: Int = 0,
    var versionName: String? = null,
    var id: Long = 0,//计划id，识别广告题材的唯一id
    var isOffer: Int = 0,
    var showType: Int = 0,
    var planName: String? = null,
    var name: String? = null,//游戏名称
    var exists: Boolean? = null,//该游戏是否存在
    var adSource: String? = null, // 数据来源
    var buttonText: String? = null,//按钮文案
    var gpLink: String? = null, //转跳gp链接
    var showContent: String? = null,//作为广告素材的展示内容

    var adType: Int? = null, // 投放类型：0:拉新,1:拉活
    var deepLink: String? = null, // deepLink
    var attributionLink: String? = null, // 点击归因链接
    var showAttributionLink: String? = null, // 展示归因链接
    var gpAttributionLink: String? = null, // gp归因链接 点击

    // 2025-08-15 PS Offer 拉活 控频需求
    var showMax: Int? = null,          // 展示数量上限, 0不限制（默认）
    var clickMax: Int? = null,         // 点击数量上限, 0不限制（默认）
    var showHours: String? = null,     // 物料展示时段：0-23, 如：0,1,2,3,10，新数据必有值，历史数据为null 0代表（0点-1点时间段）；23代表（23点-24点时间段）

) : Parcelable, Serializable {

    @Transient
    @IgnoredOnParcel
    var tAdNativeInfo: TAdNativeInfo? = null

    @Transient
    @IgnoredOnParcel
    var sceneId: String? = null

    @Transient
    @IgnoredOnParcel
    var placementId: String? = null

    @Transient
    @IgnoredOnParcel
    var palmStoreDownLoadTaskInfo: PalmStoreDownLoadTaskInfo? = null

    fun getAdTypeTxt(): String {
        return when (adType) {
            PSAdTypeEnum.PS_AD_TYPE_USER_ACQUISITION_0.value -> {
                "拉新"
            }

            PSAdTypeEnum.PS_AD_TYPE_USER_RETENTION_1.value -> {
                "拉活"
            }

            else -> {
                "未知类型"
            }
        }
    }

}