package com.transsion.ad.test

import android.graphics.Rect
import android.os.Bundle
import android.util.Log
import android.view.View
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.blankj.utilcode.util.SizeUtils
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.hisavana.common.bean.AdditionalInfo
import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.R
import com.transsion.ad.bidding.BiddingTAdditionalListener
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.bidding.icon.BiddingIconAdManager
import com.transsion.ad.bidding.icon.BiddingWrapperIconBean
import com.transsion.ad.bidding.icon.BiddingWrapperIconView
import com.transsion.ad.databinding.ActivityTestAdIconLayoutBinding
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.AdPlans
import kotlinx.coroutines.launch

/**
 * @author shmizhangxinbing
 * @date : 2025/8/20 20:58
 * @description:
 */
class TestAdIconActivity : TestBaseActivity() {

    private var iconAdapter: IconAdapter? = null
    private lateinit var binding: ActivityTestAdIconLayoutBinding

    private var adManager: BiddingIconAdManager = BiddingIconAdManager() // 广告加载对象
    private val iconList: MutableList<BiddingWrapperIconBean> = mutableListOf() // 数据源

    /**
     * 广告回调
     */
    private val listener: BiddingTAdditionalListener = object : BiddingTAdditionalListener() {

        override fun onWrapperIconReady(data: MutableList<BiddingWrapperIconBean>?) {
            super.onWrapperIconReady(data)
            iconAdapter?.setList(data)
        }

        override fun onLoadFailure(p0: TAdErrorCode?, p1: AdditionalInfo) {
            super.onLoadFailure(p0, p1)
            onLog(
                level = Log.ERROR,
                msg = "onLoadFailure() --> Hi程序化加载失败 --> errorMessage = ${p0?.errorMessage}"
            )
        }

        override fun onBiddingBuyOutError(p0: TAdErrorCode?, maxEcpmObject: BiddingIntermediateMaterialBean?) {
            super.onBiddingBuyOutError(p0, maxEcpmObject)
            AdLogger.logIcon("")
            onLog(
                level = Log.ERROR,
                msg = "onBiddingBuyOutError() --> PS兜底加载失败 --> errorMessage = ${p0?.errorMessage}"
            )
        }
    }


    // =============================================================================================


    override fun getLogTag(): String = AdLogger.TAG_AD_ICON

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdIconLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.rvIcon.apply {
            iconAdapter = IconAdapter(adManager)
            adapter = iconAdapter
            layoutManager = LinearLayoutManager(
                this@TestAdIconActivity, RecyclerView.HORIZONTAL, false
            )
            addItemDecoration(object : RecyclerView.ItemDecoration() {
                override fun getItemOffsets(
                    outRect: Rect, view: View, parent: RecyclerView, state: RecyclerView.State,
                ) {
                    super.getItemOffsets(outRect, view, parent, state)
                    val position = parent.getChildAdapterPosition(view)
                    outRect.right = SizeUtils.dp2px(12f) // 从右边添加间距
                }
            })
        }

        lifecycleScope.launch {
            adManager.loadIconAd(
                sceneId = "MBNativeTestId",
                isFilteringInstalled = true,
                targetNum = 10,
                listener = listener
            )
        }
    }


    // =============================================================================================


    class IconAdapter(val adManager: BiddingIconAdManager) :
        BaseQuickAdapter<BiddingWrapperIconBean, BaseViewHolder>(R.layout.item_test_ad_icon_layout) {

        private val designW = SizeUtils.dp2px(160f)

        override fun convert(holder: BaseViewHolder, item: BiddingWrapperIconBean) {
            val wrapperIconView =
                holder.getViewOrNull<BiddingWrapperIconView>(R.id.wrapperIconView)?.apply {
                    layoutParams.width = designW
                }
            wrapperIconView?.showData(adManager, item, TestIconAdLayoutProvider(context))
        }
    }

}