package com.transsion.ad.test

import android.os.Bundle
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import com.blankj.utilcode.util.GsonUtils
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.google.gson.reflect.TypeToken
import com.transsion.ad.R
import com.transsion.ad.databinding.ActivityTestAdPlansLayoutBinding
import com.transsion.ad.db.plan.MbAdDbPlans
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.manager.AdPlansStorageManager
import com.transsion.ad.monopoly.model.AdMaterialList
import com.transsion.ad.util.TimeUtil
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

/**
 * @author shmizhangxinbing
 * @date : 2025/6/19 14:28
 * @description: 广告计划展示
 */
class TestAdPlansActivity : TestBaseActivity() {

    private lateinit var binding: ActivityTestAdPlansLayoutBinding

    override fun getLogTag(): String = AdLogger.TAG_BASE

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdPlansLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        binding.btn.setOnClickListener {
            lifecycleScope.launch {
                withContext(Dispatchers.IO) {
                    val allAdPlans = AdPlansStorageManager.getAllAdPlans()
                    val toJson = GsonUtils.getGson().toJson(allAdPlans)
                    AdLogger.logCommon(msg = "TestAdPlansActivity --> toJson = $toJson")
                }
            }
        }

        val mAdPlanAdapter = AdPlansAdapter()
        binding.rv.apply {
            layoutManager = LinearLayoutManager(this@TestAdPlansActivity)
            adapter = mAdPlanAdapter
        }

        lifecycleScope.launch {
            withContext(Dispatchers.IO) {
                val allAdPlans = AdPlansStorageManager.getAllAdPlans()
                withContext(Dispatchers.Main) {
                    mAdPlanAdapter.setList(allAdPlans)
                    val tvTitle = "计划数量 = ${allAdPlans?.size.toString()}"
                    binding.tvTitle.text = tvTitle
                }
            }
        }
    }


    // =============================================================================================


    class AdPlansAdapter :
        BaseQuickAdapter<MbAdDbPlans, BaseViewHolder>(R.layout.test_item_ad_plan_layout) {

        override fun convert(holder: BaseViewHolder, mbAdDbPlans: MbAdDbPlans) {

            val sb = StringBuilder()
            // 素材
            val adMaterialList = GsonUtils.fromJson<List<AdMaterialList>>(
                mbAdDbPlans.adMaterialList, object : TypeToken<List<AdMaterialList>>() {}.type
            )
            if (adMaterialList.isNotEmpty()) {
                val type = adMaterialList[0].type
                sb.append("type = $type\n")
            }

            sb.append("id = ${mbAdDbPlans.id}\n").append("name = ${mbAdDbPlans.name}\n")
                .append("startTime = ${TimeUtil.convertTimestampToDate(mbAdDbPlans.startTime?.toLong())}\n")
                .append("endTime = ${TimeUtil.convertTimestampToDate(mbAdDbPlans.endTime?.toLong())}\n")
                .append("dispatchTimeStart = ${mbAdDbPlans.dispatchTimeStart}\n")
                .append("dispatchTimeEnd = ${mbAdDbPlans.dispatchTimeEnd}\n")

                .append("displayTimes = ${mbAdDbPlans.displayTimes}\n")
                .append("showedTimes = ${mbAdDbPlans.showedTimes}\n")
                .append("showDate = ${mbAdDbPlans.showDate}\n")

                .append("adSource = ${mbAdDbPlans.adSource}\n")
                .append("extAdSlot = ${mbAdDbPlans.extAdSlot}\n")
                .append("sort = ${mbAdDbPlans.sort}\n")

                .append("ctxEnableExpr = ${mbAdDbPlans.ctxEnableExpr}\n")
                .append("ctxDisableExpr = ${mbAdDbPlans.ctxDisableExpr}\n")

                .append("bidEcpmCent = ${mbAdDbPlans.bidEcpmCent}\n")
                .append("ecpmCent = ${mbAdDbPlans.ecpmCent}\n")

                .append("h5LinkPreload = ${mbAdDbPlans.h5LinkPreload}\n")

            // 展示
            holder.setText(R.id.tvConfig, sb.toString())
        }
    }

}