package com.transsion.ad.bidding.video

import android.app.Activity
import android.text.TextUtils
import com.blankj.utilcode.util.Utils
import com.hisavana.common.bean.AdditionalInfo
import com.hisavana.common.bean.TAdErrorCode
import com.hisavana.common.bean.TAdRequestBody
import com.hisavana.mediation.ad.TBaseAd
import com.hisavana.mediation.ad.TRewardedAd
import com.transsion.ad.bidding.base.AbsBiddingInterceptHiSavanaAdManager
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.MbAdType
import com.transsion.ad.scene.SceneCommonConfig
import com.transsion.ad.strategy.AdContextManager

/**
 * @author shmizhangxinbing
 * @date : 2025/6/3 10:47
 * @description:
 */
class BiddingHiSavanaVideoAdProvider : AbsBiddingInterceptHiSavanaAdManager() {

    companion object {

        /**
         * 因为所有的HiSavana 广告位ID都是服务端下发的,所以客户端会有多个对象
         */
        private val mAdMap by lazy {
            HashMap<String, BiddingHiSavanaVideoAdProvider>()
        }

        /**
         * 通过广告位ID获取广告加载对象
         */
        fun getManager(sceneId: String?): BiddingHiSavanaVideoAdProvider? {
            if (TextUtils.isEmpty(sceneId)) {
                return null
            }
            val hiSavanaPlacementId =
                SceneCommonConfig.getHiSavanaPlacementId(sceneId) ?: return null
            var manager = mAdMap[hiSavanaPlacementId]
            if (null == manager) {
                manager = BiddingHiSavanaVideoAdProvider()
                manager.setPlacementId(hiSavanaPlacementId)
                mAdMap[hiSavanaPlacementId] = manager
            }
            return manager
        }
    }


    // =============================================================================================


    /*** 广告加载对象*/
    private var tTVideoAd: TRewardedAd? = null

    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_VIDEO

    override fun getAdInstance(): TBaseAd<*>? {
        val placementId = getPlacementId()
        if (TextUtils.isEmpty(placementId)) {
            return null
        }

        // 如果对象不存在，那就创建新的
        if (null == tTVideoAd) {
            tTVideoAd = TRewardedAd(Utils.getApp(), placementId)
            tTVideoAd?.setRequestBody(
                TAdRequestBody.AdRequestBodyBuild().setAdditionalListener(this).build()
            )
        }
        return tTVideoAd
    }

    override fun show(topActivity: Activity, ctxMap: Map<String, Any>?) {
        if (AdContextManager.isDangerGenre(ctxMap)) {
            tTVideoAd?.setContainVulgarContent(true)
        }
        kotlin.runCatching {
            tTVideoAd?.show(topActivity) ?: kotlin.run {
                getListener()?.onShowError(
                    TAdErrorCode(-1, "tInterstitialAd == null"), AdditionalInfo()
                )
            }
        }.getOrElse {
            getListener()?.onShowError(
                TAdErrorCode(-1, "程序化 show 异常 it = ${it.message}"), AdditionalInfo()
            )
        }
    }

    override fun reset() {
        tTVideoAd?.destroy()
        tTVideoAd = null
    }

    override fun getLogTag(): String = AdLogger.TAG_AD_VIDEO
}