package com.transsion.ad.db.plan

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import androidx.room.Update

/**
 * @author: zhangxinbing
 * @date : 2023/12/21 19:32
 * @description:
 */
@Dao
interface MbAdPlansDao {

    /**
     * 批量更新当前数据的可用性
     */
    @Query("UPDATE mb_ad_db_plans SET isValid = :isValid WHERE version !=:newVersion")
    suspend fun updateAllValid(isValid: Boolean, newVersion: String)

    /***获取所有广告计划*/
    @Query("SELECT * FROM mb_ad_db_plans WHERE isValid = 1 ORDER BY sort")
    suspend fun getAllAdPlans(): List<MbAdDbPlans>?

    /***获取广告计划*/
    @Query("SELECT * FROM mb_ad_db_plans where adShowLevel='AdShowFirst' ORDER BY sort")
    suspend fun getAdShowFirstPlans(): List<MbAdDbPlans>?

    /***获取兜底广告计划*/
    @Query("SELECT * FROM mb_ad_db_plans where adShowLevel='AdShowFinal' ORDER BY sort")
    suspend fun getAdShowFinalPlans(): List<MbAdDbPlans>?

    /**
     * 获取所有有效广告计划
     * @param newVersion String
     * @return List<NonAdPlans>
     */
    @Query("SELECT * FROM mb_ad_db_plans where version=:newVersion")
    suspend fun getUnExpireAdPlans(newVersion: String): List<MbAdDbPlans>?


    /**
     * 获取所有有效广告计划
     * @param newVersion String
     * @return List<NonAdPlans>
     */
    @Query("SELECT * FROM mb_ad_db_plans where id=:id")
    suspend fun getPlanById(id: String?): MbAdDbPlans?

    @Query("SELECT * FROM mb_ad_db_plans where adSource=:adSource")
    suspend fun getPlansBySource(adSource: String?): List<MbAdDbPlans>?


    /***插入信息*/
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insert(mbAdDbPlans: MbAdDbPlans)

    /***插入信息*/
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insert(mbAdDbPlans: List<MbAdDbPlans>)

    /***更新信息*/
    @Update
    suspend fun update(mbAdDbPlans: MbAdDbPlans)


    /***删除所有信息*/
    @Query("DELETE FROM mb_ad_db_plans")
    suspend fun deleteAll()


    @Query("DELETE FROM mb_ad_db_plans WHERE version !=:newVersion")
    suspend fun deleteExpireVersion(newVersion: String)

}