package com.transsion.ad.monopoly.manager

import com.transsion.ad.log.AdLogger
import com.transsion.ad.log.ILog
import java.util.concurrent.atomic.AtomicBoolean

/**
 * @author shmizhangxinbing
 * @date : 2025/8/22 15:50
 * @description:
 */
abstract class BaseAdPlansAssets : ILog {

    private var isInitialized: AtomicBoolean = AtomicBoolean(false)

    override fun getLogTag(): String = AdLogger.TAG_INIT

    override fun getSceneId(): String? = ""

    /**
     * 仅初始化一次
     */
    suspend fun copyFromAssets() {
        if (isInitialized.get()) {
            return
        }
        isInitialized.set(true)
        innerCopy()
    }

    abstract suspend fun innerCopy()
}