package com.transsion.ad.monopoly.model

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

/**
 * @author: zhangxinbing
 * @date : 2025/2/13 20:57
 * @description: 广告计划 响应数据
 *
 * 接口文档
 * https://gitlab.shalltry.com/vs/idl/-/blob/master/api/wefeed/mobile/bff/wefeed-app-api.swagger.json?ref_type=heads
 */
@Parcelize
data class MbAdPlansBean(
    val version: String? = null, // 广告配置版本号
    val adPlans: MutableList<AdPlans>? = null, // 广告计划配置列表

    // MovieBox会员&内容广告屏蔽策略
    // https://transsioner.feishu.cn/docx/Pj84dFtm7oSSKnxEezBcOksTnqb
    var ctxAttributeConfig: CtxAttributeConfig? = null, // 上下文判断条件

    // 新增字段
    var genre: String? = null, // 用于HiSavana 广告SDK判断上下文

    // 广告SDK需求新增字段 2025-04-22 场景信息通过接口下发
    val versionAdScene: String? = null, // 广告场景配置版本号
    val adSceneConfigData: String? = null, // 广告场景配置数据

    // 新用户屏蔽策略
    val userCreateTime: Long? = null, // 用户创建时间戳（毫秒）
    val newUserAdShieldHour: Int? = null, // 新用户广告屏蔽时间（小时）

) : Parcelable