package com.transsion.ad.monopoly.plan

import android.text.TextUtils
import com.transsion.ad.monopoly.model.AdMaterialList
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdImage

/**
 * @author: zhangxinbing
 * @date : 2025/3/4 10:32
 * @description: 获取广告计划
 */
object MonopolyAdPlanProvider {


    /**
     * 是否是视频
     */
    fun isVideo(plan: AdPlans): Boolean {
        return getMaterial(plan)?.type == AdMaterialList.NON_AD_TYPE_VIDEO
    }

    /**
     * 获取资源对象
     */
    fun getMaterial(plan: AdPlans): AdMaterialList? {
        val adMaterial = plan.adMaterialList
        return if (adMaterial?.isNotEmpty() == true) {
            adMaterial[0]
        } else {
            null
        }
    }

    /**
     * 获取图片的连接
     */
    fun getImageUrl(plan: AdPlans): String? {
        // 如果本地地址是空的，那就不使用线上地址在线加载
        val adMaterial = getMaterial(plan)
        return if (TextUtils.isEmpty(getMaterial(plan)?.image?.path)) {
            adMaterial?.image?.url
        } else {
            adMaterial?.image?.path
        }
    }

    /**
     * 获取图片对象
     */
    fun getImage(plan: AdPlans): MbAdImage? {
        return getMaterial(plan)?.image
    }

    /**
     * 获取视频的连接
     */
    fun getVideoUrl(plan: AdPlans): String? {
        // 如果本地地址是空的，那就不使用线上地址在线加载
        val adMaterial = getMaterial(plan)
        return if (TextUtils.isEmpty(getMaterial(plan)?.video?.path)) {
            adMaterial?.video?.url
        } else {
            adMaterial?.video?.path
        }
    }

    /**
     * 获取扩展图片
     */
    fun getExtImage(plan: AdPlans): MbAdImage? {
        return plan.extImage
    }

}