package com.transsion.ad.strategy

import com.transsion.ad.scene.SceneCommonConfig

/**
 * @author shmizhangxinbing
 * @date : 2025/9/8 17:28
 * @description: 广告展示间隔时间管理器 场景维度的策略实现
 */
object DisplayIntervalTimeManager {

    private const val MMKV_KEY = "DISPLAY_INTERVAL_TIME"

    /**
     * 是否可以展示
     */
    fun canShow(sceneId: String): Boolean {
        // 展示间隔判断
        val lastTime = AdMmkv.getAdMMKV().getLong(MMKV_KEY + sceneId, 0L)
        if (lastTime == 0L) {
            return true
        }
        val intervalTime = SceneCommonConfig.getDisplayIntervalTime(sceneId)
        // 单位全部转换成毫秒单位
        return (System.currentTimeMillis() - lastTime) >= (intervalTime * 1000)
    }

    /**
     * 保存展示时间
     */
    fun saveShowTime(sceneId: String) {
        AdMmkv.getAdMMKV().putLong(MMKV_KEY + sceneId, System.currentTimeMillis())
    }

}