package com.transsion.ad.test

import android.os.Bundle
import android.util.Log
import androidx.lifecycle.lifecycleScope
import com.hisavana.common.bean.TAdErrorCode
import com.transsion.ad.bidding.BiddingTAdditionalListener
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.bidding.nativead.BiddingNativeManager
import com.transsion.ad.databinding.ActivityTestAdNativeLayoutBinding
import com.transsion.ad.log.AdLogger
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

/**
 * @author shmizhangxinbing
 * @date : 2025/6/9 17:17
 * @description:
 */
class TestAdNativeActivity : TestBaseActivity() {

    private lateinit var nativeManager: BiddingNativeManager
    private lateinit var binding: ActivityTestAdNativeLayoutBinding

    private val nativeListener = object : BiddingTAdditionalListener() {

        override fun onBiddingLoad(maxEcpmObject: BiddingIntermediateMaterialBean?) {
            super.onBiddingLoad(maxEcpmObject)
            lifecycleScope.launch {
                withContext(Dispatchers.Main) {
                    val viewBinder = TestAdNativeViewBinder(this@TestAdNativeActivity)
                    binding.nativeView.bindNativeView(
                        adManager = nativeManager, adLayoutProvider = viewBinder, maxEcpmObject = maxEcpmObject
                    )
                }
            }
        }

        override fun onBiddingError(p0: TAdErrorCode?) {
            super.onBiddingError(p0)
            onLog(level = Log.ERROR, msg = "onBiddingError() --> p0 = ${p0?.errorMessage}")
        }
    }


    // =============================================================================================


    override fun getLogTag(): String = AdLogger.TAG_AD_NATIVE

    override fun onDestroy() {
        super.onDestroy()
        nativeManager.destroy()
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdNativeLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        nativeManager = BiddingNativeManager()
        binding.btnLoadNativeAd.setOnClickListener {
            lifecycleScope.launch {
                nativeManager.setSceneId("MBNativeTestId")
                nativeManager.setCtxMap(null)
                nativeManager.setContext(this@TestAdNativeActivity)
                nativeManager.setListener(nativeListener)
                nativeManager.loadAd()
            }
        }
    }

}