package com.transsion.ad.test

import android.os.Bundle
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.LinearLayoutManager
import com.chad.library.adapter.base.BaseProviderMultiAdapter
import com.chad.library.adapter.base.module.LoadMoreModule
import com.chad.library.adapter.base.provider.BaseItemProvider
import com.chad.library.adapter.base.viewholder.BaseViewHolder
import com.transsion.ad.R
import com.transsion.ad.bidding.nativead.BiddingListManager
import com.transsion.ad.bidding.nativead.BiddingNativeManager
import com.transsion.ad.databinding.ActivityTestAdNativeListLayoutBinding
import com.transsion.ad.log.AdLogger
import com.transsion.ad.view.native_ad.NativeWrapperAdView
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

/**
 * @author shmizhangxinbing
 * @date : 2025/6/9 20:09
 * @description:
 */
class TestAdNativeListActivity : TestBaseActivity() {

    private lateinit var binding: ActivityTestAdNativeListLayoutBinding
    private var mTestAdapter: TestAdNativeListAdapter? = null
    private var v3ListManager: BiddingListManager? = null


    // =============================================================================================


    override fun getLogTag(): String = AdLogger.TAG_AD_NATIVE

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityTestAdNativeListLayoutBinding.inflate(layoutInflater)
        setContentView(binding.root)

        // 初始化广告
        initAd()
        // 初始化列表
        initList()
    }

    override fun onDestroy() {
        super.onDestroy()
        v3ListManager?.destroy()
    }

    private fun initList() {
        binding.rv.apply {
            layoutManager = LinearLayoutManager(this@TestAdNativeListActivity)
            mTestAdapter = TestAdNativeListAdapter().apply {
                loadMoreModule.isEnableLoadMore = true
                loadMoreModule.isEnableLoadMoreIfNotFullPage = true
                loadMoreModule.setOnLoadMoreListener {
                    loadMore()
                }
            }
            adapter = mTestAdapter
        }

        loadMore()
    }

    private fun loadMore() {
        lifecycleScope.launch {
            delay(1000)
            val mTestList = mutableListOf<TestAdNativeListBean>()
            repeat(5) {
                mTestList.add(TestAdNativeListBean(title = "", adManager = null))
            }
            mTestAdapter?.addData(mTestList)
            mTestAdapter?.loadMoreModule?.loadMoreComplete()
        }
    }


    private fun initAd() {
        v3ListManager = BiddingListManager().apply {
            setRecyclerView(binding.rv)
            setCoroutineScope(lifecycleScope)
            setSceneId("MBNativeTestId")
            setCtxMap(mutableMapOf())
            setAdCallback { lastAdPosition, current ->
                val size = mTestAdapter?.data?.size ?: 0
                val adBean = TestAdNativeListBean(title = "", adManager = current)
                if (lastAdPosition < size) {
                    mTestAdapter?.addData(lastAdPosition, adBean)
                } else {
                    mTestAdapter?.addData(adBean)
                }
            }
        }
    }


    // ======================================== 列表处理 =============================================


    /**
     * 组装之后的数据对象
     */
    data class TestAdNativeListBean(val title: String, val adManager: BiddingNativeManager?) {
        companion object {
            const val ITEM_CONTENT = 1
            const val ITEM_AD = 2
        }
    }

    /**
     * 列表适配器 多布局
     */
    class TestAdNativeListAdapter : BaseProviderMultiAdapter<TestAdNativeListBean>(),
        LoadMoreModule {

        init {
            addItemProvider(TestAdProvider())
            addItemProvider(TestContentProvider())
        }

        override fun getItemType(data: List<TestAdNativeListBean>, position: Int): Int {
            return if (data[position].adManager != null) {
                TestAdNativeListBean.ITEM_AD
            } else {
                TestAdNativeListBean.ITEM_CONTENT
            }
        }
    }

    /**
     * 广告样式
     */
    class TestAdProvider : BaseItemProvider<TestAdNativeListBean>() {

        override val itemViewType: Int
            get() = TestAdNativeListBean.ITEM_AD

        override val layoutId: Int
            get() = R.layout.test_ad_native_list_ad_item_layout

        override fun convert(helper: BaseViewHolder, item: TestAdNativeListBean) {
            val viewBinder = TestAdNativeViewBinder(context)
            helper.getViewOrNull<NativeWrapperAdView>(R.id.nativeView)?.bindNativeView(
                adManager = item.adManager, adLayoutProvider = viewBinder,maxEcpmObject = item.adManager?.getMaxEcpmObject()
            )
        }
    }

    /**
     * 内容
     */
    class TestContentProvider : BaseItemProvider<TestAdNativeListBean>() {

        override val itemViewType: Int
            get() = TestAdNativeListBean.ITEM_CONTENT

        override val layoutId: Int
            get() = R.layout.test_ad_native_list_content_item_layout

        override fun convert(helper: BaseViewHolder, item: TestAdNativeListBean) {
            //TODO("Not yet implemented")
        }
    }

}