package com.transsion.ad.util

import android.graphics.Color
import android.util.TypedValue
import android.view.View
import android.view.ViewGroup
import android.view.ViewTreeObserver
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import com.blankj.utilcode.util.ActivityUtils
import com.blankj.utilcode.util.ScreenUtils
import com.blankj.utilcode.util.SizeUtils
import com.transsion.ad.strategy.AdMmkv
import java.util.Locale


/**
 * @author: zhangxinbing
 * @date : 2023/12/11 15:30
 * @description:
 */
object AdUtils {

    /**
     * 是否展示下载管理边下边播引导
     */
    fun isShowDownloadingPlayBubbleGuide() =
        AdMmkv.mmkvWithID.getBoolean("key_downloading_play_bubble_guide", true)

    fun setDownloadingPlayBubbleGuide() {
        AdMmkv.mmkvWithID.putBoolean("key_downloading_play_bubble_guide", false)
    }

    /**
     * 判断字符串是否是英文
     */
    fun isEnglishString(string: String): Boolean {
        return string.matches(Regex("[a-zA-Z]+"))
    }

    // 设置标题首字母大写
    fun setTitleCapitalizeForView(layout: View, resId: Int) {
        val view = layout.findViewById<View>(resId) ?: return
        if (view is TextView) {
            view.apply {
                post {
                    kotlin.runCatching {
                        val txt = text.toString().lowercase()
                        if (isEnglishString(txt)) {
                            text =
                                txt.replaceFirstChar { if (it.isLowerCase()) it.titlecase(Locale.getDefault()) else it.toString() }
                        }
                    }
                }
            }
        }
    }

    fun setTextColorWhiteForStoreView(
        view: View,
        sizeSp: Float = 10f,
        color: Int = Color.WHITE,
        callback: ((Boolean) -> Unit)? = null
    ) {
        view.postDelayed({
            setTextProperties(view, color, sizeSp, false)
        }, 10L)
    }

    fun setTextColorWhiteForView(layout: View, resId: Int) {
        // 获取特定的视图
        val view = layout.findViewById<View>(resId) ?: return
        // 设置文本颜色为白色和大小为 10sp，并设置 includeFontPadding 为 false，延迟 10ms 后执行，避免在布局未完成时设置文本颜色
        layout.postDelayed({
            setTextProperties(view, Color.WHITE, 10f, false)
        }, 10L)
    }

    // 辅助函数，用于递归遍历视图树并设置 TextView 的文本颜色和大小
    // TODO: 2024/09/14 存在风险，需要尽快移除，需要 HiSavana 修改
    private fun setTextProperties(
        view: View, color: Int, sizeSp: Float, includeFontPadding: Boolean
    ) {
        kotlin.runCatching {
            if (view is TextView) {
                view.setTextColor(color)
                view.setTextSize(TypedValue.COMPLEX_UNIT_SP, sizeSp)
                view.includeFontPadding = includeFontPadding
                return
            } else if (view is ViewGroup) {
                for (i in 0 until view.childCount) {
                    val child = view.getChildAt(i)
                    setTextProperties(
                        child, color, sizeSp, includeFontPadding
                    )
                }
            }
        }
    }

    // 重新调整布局，适配曲面屏
    fun reAdjustLayoutForView(view: View, width: Float, height: Float, padding: Float, count: Int) {
        kotlin.runCatching {
            view.viewTreeObserver.addOnGlobalLayoutListener(object :
                ViewTreeObserver.OnGlobalLayoutListener {
                override fun onGlobalLayout() {
                    view.viewTreeObserver.removeOnGlobalLayoutListener(this)
                    val designW = SizeUtils.dp2px(width)
                    val designH = SizeUtils.dp2px(height)
                    val paddingSize = SizeUtils.dp2px(padding)
                    val screenW = ScreenUtils.getScreenWidth()
                    val targetW = (screenW - paddingSize) / count
                    val targetH = (targetW * (designH * 1.0f / designW)).toInt()
                    val layoutParams = view.layoutParams as ConstraintLayout.LayoutParams
                    layoutParams.height = targetH
                    layoutParams.width = targetW
                    view.layoutParams = layoutParams
                }
            })
        }
    }
}