package com.transsion.ad.view.native_ad

import android.content.Context
import android.util.AttributeSet
import android.util.Log
import android.view.View
import android.widget.FrameLayout
import android.widget.ImageView
import com.cloud.hisavana.sdk.api.view.MediaView
import com.cloud.hisavana.sdk.api.view.TNativeView
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo
import com.hisavana.mediation.ad.TAdNativeView
import com.hisavana.mediation.ad.TMediaView
import com.transsion.ad.bidding.base.AbsBiddingAdLayoutProvider
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.bidding.nativead.BiddingHiSavanaNativeProvider
import com.transsion.ad.bidding.nativead.BiddingHiSspNativeProvider
import com.transsion.ad.bidding.nativead.BiddingNativeManager
import com.transsion.ad.bidding.base.AbsBiddingHiSspAdLayoutProvider
import com.transsion.ad.log.AdLogger

/**
 * @author shmizhangxinbing
 * @date : 2025/6/9 17:29
 * @description: 原生广告封装一层
 */
class NativeWrapperAdView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
) : FrameLayout(context, attrs) {

    private fun getClassTag(): String = javaClass.simpleName
    private var buyoutNativeView: BiddingBuyOutNativeView? = null  // 包断广告 NativeView
    private var hiNativeView: TAdNativeView? = null  // Hi程序化 NativeView
    private var hiSspNativeView: TNativeView? = null  // Hi程序化 NativeView

    /**
     * 默认的图片样式
     */
    private var scaleType = ImageView.ScaleType.FIT_CENTER


    // =============================================================================================


    /**
     * 图片拉伸样式
     */
    fun setScaleType(scaleType: ImageView.ScaleType) {
        this.scaleType = scaleType
    }

    /**
     * 展示广告
     */
    fun bindNativeView(
        adManager: BiddingNativeManager?, // Native 广告加载对象
        adLayoutProvider: AbsBiddingAdLayoutProvider? = null, // 布局信息
        sspLayoutProvider: AbsBiddingHiSspAdLayoutProvider? = null, // SSP 使用
        maxEcpmObject: BiddingIntermediateMaterialBean?,
    ) {
        if (adManager == null || maxEcpmObject == null || (adLayoutProvider == null && sspLayoutProvider == null)) {
            AdLogger.logSdk(
                tag = AdLogger.TAG_AD_NATIVE,
                msg = "${getClassTag()} --> bindNativeView() --> 参数为空 --> maxEcpmObject = $maxEcpmObject --> adLayoutProvider = $adLayoutProvider --> sspLayoutProvider = $sspLayoutProvider",
                level = Log.ERROR,
            )
            return
        }

        if (isHiAd(maxEcpmObject)) {
            bindHiNativeAd(adManager, adLayoutProvider, maxEcpmObject)
            buyoutNativeView?.visibility = View.GONE
            hiSspNativeView?.visibility = View.GONE
            hiNativeView?.visibility = View.VISIBLE
        } else if (isHiSspAd(maxEcpmObject)) {
            bindHiSspNativeAd(adManager, sspLayoutProvider, maxEcpmObject)
            buyoutNativeView?.visibility = View.GONE
            hiNativeView?.visibility = View.GONE
            hiSspNativeView?.visibility = View.VISIBLE
        } else {
            bindBuyOutAd(adManager, adLayoutProvider, maxEcpmObject)
            buyoutNativeView?.visibility = View.VISIBLE
            hiNativeView?.visibility = View.GONE
            hiSspNativeView?.visibility = View.GONE
        }
    }

    /**
     * 模拟点击, 自动跳落地场景适用，如首页二楼广告场景
     */
    fun simulatingClick(
        maxEcpmObject: BiddingIntermediateMaterialBean?,
        adLayoutProvider: AbsBiddingAdLayoutProvider? = null,
        sspLayoutProvider: AbsBiddingHiSspAdLayoutProvider? = null, // SSP 使用
    ) {
        if (isHiAd(maxEcpmObject)) {
            hiNativeView?.findViewById<TMediaView>(adLayoutProvider?.getMediaId() ?: 0)?.performClick()
        } else if (isHiSspAd(maxEcpmObject)) {
            sspLayoutProvider?.mediaView?.performClick()
        } else {
            buyoutNativeView?.onAdClick()
        }
    }

    // =============================================================================================


    /**
     * 判断当前是什么广告类型
     */
    private fun isHiAd(maxEcpmObject: BiddingIntermediateMaterialBean? = null): Boolean {
        return maxEcpmObject?.nativeInfo != null
    }

    private fun isHiSspAd(maxEcpmObject: BiddingIntermediateMaterialBean? = null): Boolean {
        return maxEcpmObject?.sspNativeInfo != null
    }

    /**
     * 包断广告展示
     */
    private fun bindBuyOutAd(
        adManager: BiddingNativeManager?,
        adLayoutProvider: AbsBiddingAdLayoutProvider?,
        maxEcpmObject: BiddingIntermediateMaterialBean?,
    ) {
        if (buyoutNativeView == null) {
            buyoutNativeView = BiddingBuyOutNativeView(context)
            addView(buyoutNativeView)
        } else {
            //AdLogger.logSdkNativeE("${getClassTag()} --> bindBuyOutAd() --> View 复用")
        }
        // 是否已经曝光过了
        buyoutNativeView?.isReportAdDisplay(maxEcpmObject?.isExpend ?: false)
        buyoutNativeView?.setEcpmObject(maxEcpmObject)
        buyoutNativeView?.setSceneId(adManager?.getSceneId())
        buyoutNativeView?.setScaleType(scaleType)
        buyoutNativeView?.bindNativeView(adLayoutProvider)
        buyoutNativeView?.setListener(adManager)
        adManager?.addBuyOutNativeView(buyoutNativeView) // 资源回收使用
    }

    /**
     * Hi程序化广告展示
     */
    private fun bindHiNativeAd(
        adManager: BiddingNativeManager?,
        adLayoutProvider: AbsBiddingAdLayoutProvider?,
        maxEcpmObject: BiddingIntermediateMaterialBean?,
    ) {

        if (hiNativeView == null) {
            hiNativeView = TAdNativeView(context)
            addView(hiNativeView)
        } else {
            //AdLogger.logSdkNativeE("${getClassTag()} --> bindHiNativeAd() --> View 复用")
        }

        adManager?.addHiNativeView(hiNativeView) // 资源回收使用

        kotlin.runCatching {
            val nativeInfo = maxEcpmObject?.nativeInfo
            if (hiNativeView != null && adLayoutProvider != null && nativeInfo != null) {
                val hiViewBinder = adLayoutProvider.getHiViewBinder(
                    adLayoutProvider.getAdLayoutProvider(), maxEcpmObject.nativeInfo
                )
                val tNativeAd =
                    BiddingHiSavanaNativeProvider.getNativeManager(adManager?.getSceneId())
                        ?.getNativeAd()
                tNativeAd?.bindNativeView(hiNativeView!!, nativeInfo, hiViewBinder)
            }
        }
    }

    /**
     * Hi 程序化 SSP 广告渲染
     */
    private fun bindHiSspNativeAd(
        adManager: BiddingNativeManager?,
        layoutProvider: AbsBiddingHiSspAdLayoutProvider?,
        maxEcpmObject: BiddingIntermediateMaterialBean?,
    ) {
        val nativeInfo: TaNativeInfo? = maxEcpmObject?.sspNativeInfo

        if (hiSspNativeView == null) {
            hiSspNativeView = TNativeView(context)
            addView(hiSspNativeView)
        } else {
            //AdLogger.logSdkNativeE("${getClassTag()} --> bindHiNativeAd() --> View 复用")
        }

        adManager?.addHiSspNativeView(hiSspNativeView) // 资源回收使用

        hiSspNativeView?.let { nativeView ->
            layoutProvider?.let {
                kotlin.runCatching {
                    val tNative =
                        BiddingHiSspNativeProvider.getNativeManager(adManager?.getSceneId())
                            ?.getNativeAd()
                    val adContains = layoutProvider.getContainViews(nativeView, nativeInfo!!)
                    tNative?.registerViews(nativeView, adContains, nativeInfo)
                }.onFailure {
                    AdLogger.logSdk(getClassTag(), "-----> bindNativeView --> error: ${it.message}")
                }
            }
        }
    }
}