/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.ad.db.pslink;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.transsion.ad.db.pslink.AttributionPoint;
import com.transsion.ad.db.pslink.AttributionPointDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

public final class AttributionPointDao_Impl
implements AttributionPointDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<AttributionPoint> __insertAdapterOfAttributionPoint;
    private final AttributionPoint.TypeConverter __typeConverter = new AttributionPoint.TypeConverter();
    private final EntityDeleteOrUpdateAdapter<AttributionPoint> __deleteAdapterOfAttributionPoint;
    private final EntityDeleteOrUpdateAdapter<AttributionPoint> __updateAdapterOfAttributionPoint;

    public AttributionPointDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfAttributionPoint = new EntityInsertAdapter<AttributionPoint>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `attribution_points` (`id`,`psId`,`failCount`,`reportUrl`,`type`,`updateTimestamp`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull AttributionPoint entity) {
                statement.bindLong(1, (long)entity.getId());
                if (entity.getPsId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getPsId());
                }
                statement.bindLong(3, (long)entity.getFailCount());
                if (entity.getReportUrl() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getReportUrl());
                }
                String _tmp = AttributionPointDao_Impl.this.__typeConverter.fromAttributionType(entity.getType());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                statement.bindLong(6, entity.getUpdateTimestamp());
            }
        };
        this.__deleteAdapterOfAttributionPoint = new EntityDeleteOrUpdateAdapter<AttributionPoint>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `attribution_points` WHERE `id` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull AttributionPoint entity) {
                statement.bindLong(1, (long)entity.getId());
            }
        };
        this.__updateAdapterOfAttributionPoint = new EntityDeleteOrUpdateAdapter<AttributionPoint>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `attribution_points` SET `id` = ?,`psId` = ?,`failCount` = ?,`reportUrl` = ?,`type` = ?,`updateTimestamp` = ? WHERE `id` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull AttributionPoint entity) {
                statement.bindLong(1, (long)entity.getId());
                if (entity.getPsId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getPsId());
                }
                statement.bindLong(3, (long)entity.getFailCount());
                if (entity.getReportUrl() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getReportUrl());
                }
                String _tmp = AttributionPointDao_Impl.this.__typeConverter.fromAttributionType(entity.getType());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                statement.bindLong(6, entity.getUpdateTimestamp());
                statement.bindLong(7, (long)entity.getId());
            }
        };
    }

    @Override
    public Object insertAttributionPoint(AttributionPoint attributionPoint, Continuation<? super Unit> $completion) {
        if (attributionPoint == null) {
            throw new NullPointerException();
        }
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfAttributionPoint.insert(_connection, (Object)attributionPoint);
            return Unit.INSTANCE;
        }, $completion);
    }

    @Override
    public Object deleteAttributionPoint(AttributionPoint attributionPoint, Continuation<? super Unit> $completion) {
        if (attributionPoint == null) {
            throw new NullPointerException();
        }
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfAttributionPoint.handle(_connection, (Object)attributionPoint);
            return Unit.INSTANCE;
        }, $completion);
    }

    @Override
    public Object updateAttributionPoint(AttributionPoint attributionPoint, Continuation<? super Unit> $completion) {
        if (attributionPoint == null) {
            throw new NullPointerException();
        }
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfAttributionPoint.handle(_connection, (Object)attributionPoint);
            return Unit.INSTANCE;
        }, $completion);
    }

    @Override
    public Object getAttributionPointsByType(AttributionPoint.AttributionType type, Continuation<? super List<AttributionPoint>> $completion) {
        String _sql = "SELECT * FROM attribution_points WHERE type = ?";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM attribution_points WHERE type = ?");){
                int _argIndex = 1;
                String _tmp = this.__typeConverter.fromAttributionType(type);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfPsId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"psId");
                int _columnIndexOfFailCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"failCount");
                int _columnIndexOfReportUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reportUrl");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfUpdateTimestamp = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updateTimestamp");
                ArrayList<AttributionPoint> _result = new ArrayList<AttributionPoint>();
                while (_stmt.step()) {
                    int _tmpId = (int)_stmt.getLong(_columnIndexOfId);
                    String _tmpPsId = _stmt.isNull(_columnIndexOfPsId) ? null : _stmt.getText(_columnIndexOfPsId);
                    int _tmpFailCount = (int)_stmt.getLong(_columnIndexOfFailCount);
                    String _tmpReportUrl = _stmt.isNull(_columnIndexOfReportUrl) ? null : _stmt.getText(_columnIndexOfReportUrl);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    AttributionPoint.AttributionType _tmpType = this.__typeConverter.toAttributionType(_tmp_1);
                    long _tmpUpdateTimestamp = _stmt.getLong(_columnIndexOfUpdateTimestamp);
                    AttributionPoint _item = new AttributionPoint(_tmpId, _tmpPsId, _tmpFailCount, _tmpReportUrl, _tmpType, _tmpUpdateTimestamp);
                    _result.add(_item);
                }
                ArrayList<AttributionPoint> arrayList = _result;
                return arrayList;
            }
        }, $completion);
    }

    @Override
    public Object getAllAttributionPoints(Continuation<? super List<AttributionPoint>> $completion) {
        String _sql = "SELECT * FROM attribution_points";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM attribution_points");){
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfPsId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"psId");
                int _columnIndexOfFailCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"failCount");
                int _columnIndexOfReportUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reportUrl");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfUpdateTimestamp = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updateTimestamp");
                ArrayList<AttributionPoint> _result = new ArrayList<AttributionPoint>();
                while (_stmt.step()) {
                    int _tmpId = (int)_stmt.getLong(_columnIndexOfId);
                    String _tmpPsId = _stmt.isNull(_columnIndexOfPsId) ? null : _stmt.getText(_columnIndexOfPsId);
                    int _tmpFailCount = (int)_stmt.getLong(_columnIndexOfFailCount);
                    String _tmpReportUrl = _stmt.isNull(_columnIndexOfReportUrl) ? null : _stmt.getText(_columnIndexOfReportUrl);
                    String _tmp = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    AttributionPoint.AttributionType _tmpType = this.__typeConverter.toAttributionType(_tmp);
                    long _tmpUpdateTimestamp = _stmt.getLong(_columnIndexOfUpdateTimestamp);
                    AttributionPoint _item = new AttributionPoint(_tmpId, _tmpPsId, _tmpFailCount, _tmpReportUrl, _tmpType, _tmpUpdateTimestamp);
                    _result.add(_item);
                }
                ArrayList<AttributionPoint> arrayList = _result;
                return arrayList;
            }
        }, $completion);
    }

    @Override
    public Object getTopAttributionPoints(long currentTimestamp, long timeThreshold, Continuation<? super AttributionPoint> $completion) {
        String _sql = "SELECT * FROM attribution_points WHERE ? - updateTimestamp >= ? ORDER BY CASE type WHEN 'CLICK' THEN 0 ELSE 1 END, failCount ASC, updateTimestamp DESC LIMIT 1";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM attribution_points WHERE ? - updateTimestamp >= ? ORDER BY CASE type WHEN 'CLICK' THEN 0 ELSE 1 END, failCount ASC, updateTimestamp DESC LIMIT 1");){
                AttributionPoint _result;
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, currentTimestamp);
                _argIndex = 2;
                _stmt.bindLong(_argIndex, timeThreshold);
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfPsId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"psId");
                int _columnIndexOfFailCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"failCount");
                int _columnIndexOfReportUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reportUrl");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfUpdateTimestamp = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updateTimestamp");
                if (_stmt.step()) {
                    int _tmpId = (int)_stmt.getLong(_columnIndexOfId);
                    String _tmpPsId = _stmt.isNull(_columnIndexOfPsId) ? null : _stmt.getText(_columnIndexOfPsId);
                    int _tmpFailCount = (int)_stmt.getLong(_columnIndexOfFailCount);
                    String _tmpReportUrl = _stmt.isNull(_columnIndexOfReportUrl) ? null : _stmt.getText(_columnIndexOfReportUrl);
                    String _tmp = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    AttributionPoint.AttributionType _tmpType = this.__typeConverter.toAttributionType(_tmp);
                    long _tmpUpdateTimestamp = _stmt.getLong(_columnIndexOfUpdateTimestamp);
                    _result = new AttributionPoint(_tmpId, _tmpPsId, _tmpFailCount, _tmpReportUrl, _tmpType, _tmpUpdateTimestamp);
                } else {
                    _result = null;
                }
                AttributionPoint attributionPoint = _result;
                return attributionPoint;
            }
        }, $completion);
    }

    @Override
    public Object isAttributionPointExists(String psId, AttributionPoint.AttributionType type, String reportUrl2, Continuation<? super Boolean> $completion) {
        String _sql = "SELECT EXISTS(SELECT 1 FROM attribution_points WHERE psId = ? AND type = ? AND reportUrl = ?)";
        return DBUtil.performSuspending((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT EXISTS(SELECT 1 FROM attribution_points WHERE psId = ? AND type = ? AND reportUrl = ?)");){
                Integer _tmp_1;
                int _argIndex = 1;
                if (psId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, psId);
                }
                _argIndex = 2;
                String _tmp = this.__typeConverter.fromAttributionType(type);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                _argIndex = 3;
                if (reportUrl2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, reportUrl2);
                }
                Boolean _result = _stmt.step() ? ((_tmp_1 = _stmt.isNull(0) ? null : Integer.valueOf((int)_stmt.getLong(0))) == null ? null : Boolean.valueOf(_tmp_1 != 0)) : null;
                Boolean bl = _result;
                return bl;
            }
        }, $completion);
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

