package com.transsion.ad.bidding.base

import android.content.Context
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.cloud.hisavana.sdk.api.view.AdChoicesView
import com.cloud.hisavana.sdk.api.view.AdCloseView
import com.cloud.hisavana.sdk.api.view.MediaView
import com.cloud.hisavana.sdk.api.view.StoreMarkView
import com.cloud.hisavana.sdk.api.view.TNativeView
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo

/**
 * @author Connor
 * @date : 2025/9/10
 * @description: 
 */
abstract class AbsBiddingHiSspAdLayoutProvider(val context: Context) {

    abstract val rootView: View
    abstract val mediaView: MediaView?
    abstract val iconView: ImageView?
    abstract val titleView: TextView?
    abstract val descriptionView: TextView?
    abstract val callToActionView: TextView?
    abstract val adChoiceView: AdChoicesView?
    abstract val adCloseView: AdCloseView?
    abstract val psMarkView: StoreMarkView?

    fun getContainViews(nativeView: TNativeView, nativeInfo: TaNativeInfo): List<View> {
        val actionContains = mutableListOf<View>()

        mediaView?.let {
            nativeView.setMediaView(it, ImageView.ScaleType.FIT_XY)
            actionContains.add(it)
        }

        iconView?.let {
            nativeView.setIconView(it)
            actionContains.add( it)
        }

        adChoiceView?.let {
            nativeView.setAdChoiceView(it)
            actionContains.add( it)
        }

        adCloseView?.let {
            nativeView.setAdCloseView(it)
            actionContains.add( it)
        }

        psMarkView?.let {
            nativeView.setPsMarkView(it)
            actionContains.add( it)
        }

        titleView?.apply {
            text = nativeInfo.title
            actionContains.add(this)
        }
        descriptionView?.apply {
            text = nativeInfo.description
            actionContains.add(this)
        }

        callToActionView?.apply {
            text = nativeInfo.ctatext
            actionContains.add(this)
        }

        nativeView.addView(rootView)

        return actionContains
    }
}