package com.transsion.ad.bidding.base

import android.os.Parcelable
import android.view.View
import androidx.annotation.Keep
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo
import com.hisavana.common.bean.TAdNativeInfo
import com.transsion.ad.bidding.banner.BiddingHiSavanaBannerProvider
import com.transsion.ad.monopoly.model.AdPlans
import kotlinx.parcelize.IgnoredOnParcel
import kotlinx.parcelize.Parcelize

/**
 * @author shmizhangxinbing
 * @date : 2025/5/27 20:22
 * @description:
 */
@Keep
@Parcelize
data class BiddingIntermediateMaterialBean(
    val ecpm: Double? = null, // 价格用于比较
    val plans: AdPlans? = null, // 广告计划
    @IgnoredOnParcel val nativeInfo: TAdNativeInfo? = null, // Hi程序化广告对象
    @IgnoredOnParcel val sspNativeInfo: TaNativeInfo? = null, // HiSSP 程序化广告对象
    @IgnoredOnParcel val hiSavanaBannerProvider: BiddingHiSavanaBannerProvider? = null,
    @IgnoredOnParcel var bannerView: View? = null, // Banner 加载成功返回的View
    @IgnoredOnParcel val hiSavanaInterceptProvider: AbsBiddingInterceptHiSavanaAdManager? = null,
    var isExpend: Boolean? = false, // 是否消耗了
    var sceneId: String? = null, // 场景ID
    var sceneSubId: String? = null, // 场景ID
) : Parcelable