package com.transsion.ad.bidding.base

import com.transsion.ad.monopoly.model.MbAdType

/**
 * @author shmizhangxinbing
 * @date : 2025/6/5 09:55
 * @description:
 * 基于广告展示回调判断当前是否有广告正在展示
 */
object InterceptUtil {

    /**
     * 插屏激励视频广告正在展示
     */
    private var isInterceptAdShowed: Boolean = false

    /**
     * AbsAdBidding --> startAdActivity()
     *
     * Activity广告唯一打开API调用，用来标记广告展示状态，用来拦截广告展示逻辑。
     */
    fun onAdShow() {
        isInterceptAdShowed = true
    }

    /**
     * AbsAdBidding --> onBiddingWrapperAdClose()
     *                  onBiddingWrapperAdShowError()
     *
     * Activity广告唯一关闭API调用，用来标记广告展示状态，用来拦截广告展示逻辑。
     */
    fun onAdClose() {
        isInterceptAdShowed = false
    }

    fun isInterceptAd(adType: Int): Boolean {
        return adType == MbAdType.MB_AD_TYPE_VIDEO || adType == MbAdType.MB_AD_TYPE_INTERSTITIAL || adType == MbAdType.MB_AD_TYPE_SPLASH
    }

    /**
     * 这个用来判断当前是否有激励视频、插屏、开屏广告展示
     */
    fun isInterceptAdShowed() = isInterceptAdShowed

}