package com.transsion.ad.bidding.splash

import com.transsion.ad.bidding.base.AbsAdBidding
import com.transsion.ad.bidding.gemini.AbsBiddingBuyOutGemini
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.bidding.gemini.BiddingBuyOutSplashGemini
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdType

/**
 * @author shmizhangxinbing
 * @date : 2025/5/30 10:18
 * @description: 开屏广告加载
 */
class BiddingSplashManager : AbsAdBidding() {

    private val gemini = BiddingBuyOutSplashGemini()


    // =================================== BuyOut 广告回调 开屏广告需要特殊处理 =========================


    override fun onBiddingBuyOutClose(maxEcpmObject: BiddingIntermediateMaterialBean?) {
        super.onBiddingBuyOutClose(maxEcpmObject)
        // TODO 开屏广告特殊处理
        getListener()?.onBiddingBuyOutClose(maxEcpmObject)
        destroy()
    }


    // ====================================== 子类实现逻辑 ===========================================


    override fun getLogTag(): String = AdLogger.TAG_AD_SPLASH

    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_SPLASH

    override fun getGemini(): AbsBiddingBuyOutGemini = gemini

    override fun addHiSavanaProvider(
        biddingPlan: MutableList<BiddingIntermediateMaterialBean>, adPlans: AdPlans, fetchCount: Int
    ) {
        // TODO 当前开屏不支持 Hi程序化广告
    }

}