package com.transsion.ad.bidding.video

import android.util.Log
import com.transsion.ad.bidding.base.AbsAdBidding
import com.transsion.ad.bidding.gemini.AbsBiddingBuyOutGemini
import com.transsion.ad.bidding.base.BiddingIntermediateMaterialBean
import com.transsion.ad.bidding.gemini.BiddingBuyOutVideoGemini
import com.transsion.ad.log.AdLogger
import com.transsion.ad.monopoly.model.AdPlans
import com.transsion.ad.monopoly.model.MbAdType

/**
 * @author shmizhangxinbing
 * @date : 2025/5/30 18:03
 * @description:
 */
class BiddingVideoManager : AbsAdBidding() {

    companion object {

        fun preLoadAd(sceneId: String) {
            BiddingHiSavanaVideoAdProvider.getManager(sceneId)?.preLoadAd()
        }
    }

    private val gemini = BiddingBuyOutVideoGemini()

    // =============================================================================================


    override fun getAdType(): Int = MbAdType.MB_AD_TYPE_VIDEO

    override fun getLogTag(): String = AdLogger.TAG_AD_VIDEO

    override fun getGemini(): AbsBiddingBuyOutGemini = gemini

    override fun addHiSavanaProvider(
        biddingPlan: MutableList<BiddingIntermediateMaterialBean>,// 竞价队列
        adPlans: AdPlans, // 广告计划
        fetchCount: Int, // 竞价队列数量，仅Native有效
    ) {

        val video = BiddingHiSavanaVideoAdProvider.getManager(getSceneId())
        val additionalInfo = video?.getAdditionalInfo()

        // 同步获取到了就添加到竞价队列
        if (additionalInfo != null) {
            if (isUseHiEcpm(adPlans)) {
                adPlans.bidEcpmCent = additionalInfo.ecpm
            }

            biddingPlan.add(
                BiddingIntermediateMaterialBean(
                    ecpm = adPlans.bidEcpmCent,
                    plans = adPlans,
                    nativeInfo = null,
                    isExpend = false,
                    hiSavanaInterceptProvider = video
                )
            )

            video.enterScene(getSceneId())
        } else {
            onLog(
                Log.ERROR,
                msg = "addHiSavanaProvider() --> 激励视频广告同步获取失败 --> additionalInfo == null",
                writeToFile = false
            )
        }
    }
}