package com.transsion.ad.log

import android.text.TextUtils
import android.util.Log

/**
 * @author shmizhangxinbing
 * @date : 2025/6/4 15:56
 * @description: 日志输出
 */
interface ILog {

    /**
     * 不同的 tag 表示不同的业务线
     */
    fun getLogTag(): String

    /**
     * 场景ID
     */
    fun getSceneId(): String?

    /**
     * 调用日志的类
     */
    fun getClassTag(): String = javaClass.simpleName

    /**
     * 统一输出日志
     */
    fun onLog(
        level: Int = Log.DEBUG, msg: String, tag: String = getLogTag(), writeToFile: Boolean = true
    ) {
        val cusMsg = if (TextUtils.isEmpty(getSceneId())) {
            "${getClassTag()} --> $msg"
        } else {
            "${getClassTag()} --> sceneId = ${getSceneId()} --> $msg"
        }
        AdLogger.logSdk(
            tag = getLogTag(), msg = cusMsg, level = level, writeToFile = writeToFile
        )
    }

}