package com.transsion.ad.monopoly.intercept

import com.transsion.ad.db.plan.MbAdDbPlans

/**
 * @author: zhangxinbing
 * @date : 2024/8/21 14:15
 * @description: 广告计划上下文判断 黑名单
 */
internal class AdSceneCtxDisableExprHandler : BaseAdSceneCtxExprHandler() {

    override fun getCtxExprString(
        sceneId: String, plans: MbAdDbPlans?, ctxMap: Map<String, Any>
    ): String? = plans?.ctxDisableExpr

    override fun getMissMsg(): String = "未命中 黑名单,当前广告计划 满足展示条件"

    override fun getHitMsg(): String = "命中 黑名单,当前广告计划 不满足展示条件"

    override fun goNext(enable: Boolean): Boolean = enable.not()

}