package com.transsion.ad.monopoly.manager

import android.text.TextUtils
import android.util.Log
import com.transsion.ad.scene.SceneStorage
import com.transsion.ad.util.AssetsUtil
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

/**
 * @author shmizhangxinbing
 * @date : 2025/6/12 19:57
 * @description: 内置场景
 */
object AdSceneAssetsManager : BaseAdPlansAssets() {

    /**
     * 将资源文件保存到下载目录中
     */
    override suspend fun innerCopy() {
        withContext(Dispatchers.IO) {
            kotlin.runCatching {
                if (SceneStorage.hasData()) {
                    onLog(level = Log.INFO, msg = "innerCopy() --> 数据已经存在")
                    return@withContext
                }

                // 读取assets文件夹下的配置文件
                val readAssets = AssetsUtil.readAssets("assets_scene.json")
                // 非空判断
                if (TextUtils.isEmpty(readAssets).not()) {
                    onLog(
                        level = Log.INFO, msg = "innerCopy() --> readAssets = $readAssets"
                    )
                    SceneStorage.setScene4Assets(readAssets)
                } else {
                    onLog(
                        level = Log.ERROR,
                        msg = "innerCopy() --> assets数据 -- 保存数据库失败 -- fail fail fail -- readAssets = null"
                    )
                }
            }.getOrElse {
                onLog(
                    level = Log.ERROR,
                    msg = "innerCopy() --> 保存本地数据异常 -- error error error --> it = $it"
                )
            }
        }
    }

}