package com.transsion.ad.monopoly.model

import com.tn.lib.net.interceptor.BaseUrlInterceptor
import retrofit2.http.GET
import retrofit2.http.Headers
import retrofit2.http.Query
import retrofit2.http.Url

/**
 * @author: zhangxinbing
 * @date : 2023/12/20 15:39
 * @description: 非标广告计划接口
 */
interface MbAdConfigApi {

    /**
     * 接口文档 https://gitlab.shalltry.com/vs/idl/-/blob/master/api/wefeed/mobile/bff/wefeed-app-api.swagger.json
     */
    //@Headers("${BaseUrlInterceptor.MULTIPLE_BASE_URL_TAG}:https://test-mse-api.aoneroom.com")
    @GET
    suspend fun getAdConfig(
        @Url url: String, // 使用 @Url 注解
        @Query("version") version: String,
        @Query("versionAdScene") versionAdScene: String?,
        @Query("withAdScene") withAdScene: Boolean = true
    ): MbAdPlansDto?

}