package com.transsion.ad.ps

import com.blankj.utilcode.util.GsonUtils
import com.transsion.ad.MbAdContents
import com.transsion.ad.ps.model.PsLinkAdInfo
import com.transsion.ad.util.FileUtil
import java.io.File

/**
 * @author shmizhangxinbing
 * @date : 2025/8/18 16:48
 * @description:
 */
object PsStorageManager {

    /**
     * 删除无效资源
     */
    suspend fun deleteInvalidFile() {
        val filePathSet = HashSet<String?>()
        PsDbManager.getAllPsLink()?.forEach { psAdPlan ->
            val psAdInfo = GsonUtils.fromJson(psAdPlan.psLinkAdInfoStr, PsLinkAdInfo::class.java)
            filePathSet.add(psAdInfo.path)
            filePathSet.add(psAdInfo.advertiserAvatarPath)
        }

        // 删除过期资源
        val destinationDir = MbAdContents.NON_AD_PS_DOWNLOAD_FILE_PATH + File.separatorChar
        FileUtil.deleteFile(File(destinationDir), set = filePathSet)
    }

}