package com.transsion.ad.report

import com.transsion.ad.scene.SceneGlobalConfig
import com.transsion.base.report.athena.Report

/**
 * @author: zhangxinbing
 * @date : 2025/4/2 20:48
 * @description: 埋点
 */
internal object AdReportManager {

    private fun getClassTag(): String = javaClass.simpleName


    // =============================================================================================


    /**
     * 广告SDK埋点集中处理
     *
     * 实际埋点上报仅需要修改此一处即可
     */
    fun onReport(event: String, map: MutableMap<String, String?>, pageName: String?) {

        // 埋点是有开关的
        if (SceneGlobalConfig.isAdLinkClosed()) {
            //AdLogger.logAdReport("${getClassTag()} --> 广告数据上报链路已关闭，不上报 -- map = $map")
            return
        }

        //AdLogger.logAdReport("${getClassTag()} --> onReport() --> event = $event --> pageName = $pageName --> map = $map")
        // 媒体自行上报
        Report.reportEventV2(event = event, map = map, pageName = pageName ?: "")

        //getCallback()?.onReport(event = event, map = map, pageName = pageName)?: kotlin.run {
        //    AdLogger.logAdReport("${getClassTag()} --> onReport() --> 没有初始化")
        //}
    }
}